<!--##
<NAME>Shopping cart</NAME>
<DESC>Shopping cart page</DESC>
<SECTION>Platform||Checkout</SECTION>
##-->

<!--## PAGE TITLE ELEMENT ##-->
<inp2:m_DefineElement name="page_title">
	<inp2:m_Phrase label="lu_title_ShoppingCart"/><inp2:m_if check="orditems_TotalRecords"> (<inp2:orditems_TotalRecords/>)</inp2:m_if>
</inp2:m_DefineElement>
<!--## //PAGE TITLE ELEMENT ##-->

<!--## SIDE-BAR ELEMENT ##-->
<inp2:m_DefineElement name="sidebar">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/checkout_steps.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/login.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="platform/elements/side_boxes/search.elm" design="blue_box"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement name="in-commerce/elements/side_boxes/recent_products.elm" design="blue_box" data_exists="1"/>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## /SIDE-BAR ELEMENT ##-->

<!--## MAIN CONTENT ##-->
<inp2:m_DefineElement name="content">
	<div class="movable-area">
		<div class="movable-element">
			<inp2:m_include template="platform/elements/navigation_bar.elm" titles="lu_title_ShoppingCart" templates="in-commerce/checkout/shop_cart"/>
		</div>
		<div class="movable-element">
			<inp2:m_RenderElement design="content_box">
				<inp2:m_Capture to_var="header">
					<inp2:m_Phrase label="lu_title_ShoppingCart"/><inp2:m_if check="orditems_TotalRecords"> (<inp2:orditems_TotalRecords/>)</inp2:m_if>
				</inp2:m_Capture>

				<form method="post" action="<inp2:m_FormAction />">

				<inp2:m_if check="ord_CartHasError">
					<table class="warning-message fullwidth">
						<tr>
							<td width="30">
								<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/warning_icon.gif" width="21" height="18" alt=""/>
							</td>
							<td>
								<inp2:m_phrase name="lu_Warning"/>
							</td>
						</tr>
					</table>
					<br />
					<inp2:ord_CheckoutError state_changed="lu_comm_msg_state_changed" qty_unavailable="lu_comm_msg_qty_unavailable" outofstock="lu_comm_msg_outofstock"
											coupon_applied="lu_comm_CouponApplied"
											gift_certificate_applied="lu_comm_GiftCertificateApplied"
											invalid_code="lu_comm_invalid_code" code_expired="lu_comm_code_expired"
											min_qty="lu_min_qty_error" code_removed="lu_comm_CouponRemoved"
											gc_code_removed="lu_comm_GiftCertificateRemoved"
											code_removed_automatically="lu_comm_CouponIsNotEffective"
											gc_code_removed_automatically="lu_comm_GiftCertificateIsNotEffective"
											changed_after_login="lu_comm_CartChangedAfterLogin" /><br /><br />
				</inp2:m_if>

				<table class="fullwidth">
					<inp2:m_DefineElement name="shop_cart_header">
						<tr>
							<td colspan="5">
								<div class="horizontal-separator"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/s.gif" width="1" height="1" alt="" /></div>
							</td>
						</tr>
						<tr class="sub-section-header">
							<td><inp2:m_Phrase label="lu_comm_ProductDescription"/></td>
							<td width="60"><inp2:m_Phrase label="lu_comm_YourPrice"/></td>
							<td width="50"><inp2:m_Phrase label="lu_comm_Qty"/>.</td>
							<td width="50"><inp2:m_Phrase label="lu_comm_Total"/></td>
							<td width="25">&nbsp;</td>
						</tr>
						<tr>
							<td colspan="5">
								<div class="horizontal-separator"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/s.gif" width="1" height="1" alt="" /></div>
							</td>
						</tr>
					</inp2:m_DefineElement>

					<inp2:m_include template="in-commerce/elements/options_blocks.elm"/>

					<inp2:m_DefineElement name="shop_cart_item">
						<tr>
							<td class="shopping-cart-cell-item-padding">

								<table>
									<tr>
										<td class="shopping-cart-icpn-padding-right">
											<img src="<inp2:m_TemplatesBase module="In-Commerce"/>img/shopping_cart_item.gif" width="16" height="14" alt="" />
										</td>
										<td>
											<inp2:m_if check="FieldEquals" field="Virtual" value="0">
												<a href="<inp2:ProductLink template="__default__"/>"><inp2:Field name="Name" /></a>
												<inp2:m_if check="ord_FreePromoShippingAvailable">&nbsp;<sup><inp2:m_phrase label="lu_cart_FreeShippingAvailable" /></sup>
												</inp2:m_if>
											<inp2:m_else/>
												<inp2:Field name="Name" />
											</inp2:m_if>

											<inp2:m_if check="ord_BackorderFlag"> <span class="error"><inp2:m_phrase label="lu_cart_BackorderFlag" /></span></inp2:m_if>
											<inp2:m_if check="HasOptions">
												<br/>
												<span style="font-size: 8pt">
												<inp2:m_if check="DisplayOptionsPricing">
													<inp2:PrintOptions render_as="option_element" currency="selected"/>
												<inp2:m_else/>
													<inp2:PrintOptions render_as="option_element_no_price" currency="selected"/>
												</inp2:m_if>
												<inp2:m_if check="FieldEquals" field="OptionsSelectionMode" value="0">
													<a href="<inp2:m_link template="__default__" pass="m,p,orditems"/>"><inp2:m_Phrase label="lu_comm_edit_options"/></a>
												</inp2:m_if>
												</span>
											</inp2:m_if>
											<inp2:m_if check="p_CustomField" name="Availability">
												<br />
												<inp2:p_CustomField name="Availability"/>
											</inp2:m_if>
											<inp2:m_if check="HasDiscount">
												<br />
												<inp2:m_Phrase label="lu_comm_RegularPrice" />: <inp2:Field name="FlatPrice" currency="selected"/><br />
												<inp2:m_Phrase label="lu_comm_Discount" />: <span class="price1"><inp2:Field name="ItemDiscount" currency="selected" negative="1" /></span>
												<!--<a href="javascript:showDiscountInfo('<inp2:ord_DiscountHelpLink template="in-commerce/checkout/discount_info" />')">[?]</a>-->
											</inp2:m_if>

										</td>
									</tr>
								</table>


							</td>
							<td class="shopping-cart-cell-item-padding"><strong><inp2:Field name="Price" currency="selected"/></strong></td>
							<td class="shopping-cart-cell-item-padding">
								<inp2:m_if check="IsTangible">

									<inp2:m_if check="m_ModuleEnabled" module="In-Auction">
										<inp2:m_if check="ebay-sections_IseBayItem">
											<inp2:Field field="Quantity"/>
										<inp2:m_else />
											<input value="<inp2:Field field="Quantity"/>" style="width:20px" class="input-text" name="<inp2:InputName field="Quantity"/>" />
										</inp2:m_if>
									<inp2:m_else />
										<input value="<inp2:Field field="Quantity"/>" style="width:20px" class="input-text" name="<inp2:InputName field="Quantity"/>" />
									</inp2:m_if>
									<!--<inp2:m_if check="ProductsInStock">
										<inp2:m_Phrase name="lu_of"/> <inp2:ProductsInStock/>
									</inp2:m_if>-->
								<inp2:m_else />
									1
								</inp2:m_if>
							</td>
							<td class="shopping-cart-cell-item-padding"><strong><inp2:Field name="ExtendedPrice" currency="selected"/></strong></td>
							<td class="shopping-cart-cell-item-padding" align="center">
								<inp2:m_if check="m_ModuleEnabled" module="In-Auction">
									<inp2:m_if check="ebay-sections_IseBayItem">
										&nbsp;
									<inp2:m_else />
										<a href="<inp2:LinkRemoveFromCart/>"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/delete.gif" title="Delete" alt="Delete" width="8" height="10" border="0" /></a>
									</inp2:m_if>
								<inp2:m_else />
									<a href="<inp2:LinkRemoveFromCart/>"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/delete.gif" title="Delete" alt="Delete" width="8" height="10" border="0" /></a>
								</inp2:m_if>
							</td>
						</tr>
						<tr>
							<td colspan="5">
								<div class="horizontal-separator"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/s.gif" width="1" height="1" alt="" /></div>
							</td>
						</tr>
					</inp2:m_DefineElement>


					<inp2:m_DefineElement name="shop_cart_footer">
					</table>

					<table width="100%">
						<tr >
							<td class="cart-subtotal">
								<table width="100%">
								<inp2:m_if check="ord_HasDiscount">
									<tr>
										<td>
											<strong><inp2:m_Phrase label="lu_comm_TotalSavings" />:</strong>&nbsp;
										</td>
										<td>
											<span class="price1"><strong><inp2:ord_Field name="DiscountTotal" currency="selected" /></strong></span>
										</td>
									</tr>
									<tr>
										<td colspan="2">
											<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/s.gif" width="1" height="5" alt="" />
										</td>
									</tr>
								</inp2:m_if>
								<inp2:m_if check="ord_Field" name="CouponId">
									<tr>
										<td>
											<inp2:m_Phrase label="lu_comm_CouponHasBeenApplied" />:&nbsp;
										</td>
										<td>
											<inp2:ord_Field field="CouponName" />&nbsp;&nbsp;

											<a href="<inp2:ord_RemoveCouponLink type="coupon"/>"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/delete.gif" title="<inp2:m_Phrase label="lu_comm_RemoveCoupon"/>" alt="<inp2:m_Phrase label="lu_comm_RemoveCoupon"/>" width="8" height="10" border="0" /></a>
										</td>
									</tr>
								<inp2:m_else />
									<tr>
										<td><inp2:m_Phrase label="lu_comm_EnterCouponCode" />:&nbsp;</td>
										<td><input size="15" class="input-text"  name="coupon_code" /></td>
									</tr>
								</inp2:m_if>
								<tr>
									<td colspan="2">
										<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/s.gif" width="1" height="3" alt="" />
									</td>
								</tr>
								<inp2:m_if check="ord_Field" name="GiftCertificateId">
									<tr>
										<td><inp2:m_Phrase label="lu_comm_GiftCertificateHasBeenApplied" />:&nbsp;</td>
										<td>
											<inp2:ord_Field field="GiftCertificateDiscount" currency="selected" />&nbsp;&nbsp;
											<a href="<inp2:ord_RemoveCouponLink type="gift_certificate"/>"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/delete.gif" title="<inp2:m_Phrase label="lu_comm_RemoveGiftCertificate"/>" alt="<inp2:m_Phrase label="lu_comm_RemoveGiftCertificate"/>" width="8" height="10" border="0" /></a>
										</td>
									</tr>
								<inp2:m_else />
									<tr>
										<td><inp2:m_Phrase label="lu_comm_EnterGiftCertificateCode" />:&nbsp;</td>
										<td><input size="15" class="input-text"  name="giftcert_code" /></td>
									</tr>
								</inp2:m_if>
								</table>
							</td>
							<td class="cart-subtotal" align="right">
								<span class="cart-subtotal-text"><inp2:m_Phrase label="lu_comm_Subtotal"/>: <inp2:ord_Field field="SubtotalWithDiscount" currency="selected"/></span>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<img src="<inp2:m_TemplatesBase module="In-Portal"/>img/s.gif" width="1" height="2" alt="" /><br />
								<div class="horizontal-separator"><img src="<inp2:m_TemplatesBase module="In-Portal"/>img/s.gif" width="1" height="1" alt="" /></div>
							</td>
						</tr>
						<input type="hidden" name="next_step_template" value="<inp2:m_if check="ord_OrderHasTangibleItems">in-commerce/checkout/shipping<inp2:m_else/>in-commerce/checkout/billing</inp2:m_if>" />
						<tr>
							<td class="shopping-cart-button-padding">
								<input class="button" type="submit" name="events[ord][OnUpdateCart]" value="<inp2:m_Phrase label="lu_comm_UpdateCart"/>" />
								&nbsp;
								<input class="button" type="submit" name="events[ord][OnCleanupCart]" onclick="return confirm('<inp2:m_Phrase label="lu_comm_ClearCartConfirmation" />')" value="<inp2:m_Phrase label="lu_comm_CleanupCart"/>" />
							</td>
							<td class="shopping-cart-button-padding" align="right">

								<input type="hidden" name="continue_shopping_template" value="__default__"/>
								<input class="button" type="submit" name="events[ord][OnContinueShopping]" value="<inp2:m_Phrase label="lu_comm_Continue_Shopping"/>">
								&nbsp;
								<input class="button" type="submit" name="events[ord][OnCheckout]" value="<inp2:m_Phrase label="lu_comm_ProceedCheckout"/>" />
							</td>
						</tr>
					</inp2:m_DefineElement>

					<inp2:m_DefineElement name="shop_cart_empty">
						<tr>
							<td>
								<strong><inp2:m_Phrase label="lu_comm_YourCartIsEmpty"/></strong>
							</td>
						</tr>
					</inp2:m_DefineElement>

					<script language="JavaScript">
					function showDiscountInfo(url)
					{
						window.open(url, null, 'scrollbars=no,menubar=no,toolbars=no,width=300,height=150');
					}
					</script>

					<inp2:ord_PrintCart item_render_as="shop_cart_item" header_render_as="shop_cart_header" footer_render_as="shop_cart_footer" empty_cart_render_as="shop_cart_empty" per_page="-1"/>
				</table>
				</form>

				<inp2:m_if check="ord_CartNotEmpty">
					<inp2:m_if check="ord_HasPaymentGateway" name="Google Checkout">
						<inp2:m_DefineElement name="google_checkout_button">
							<form method="POST" target="_blank" action="<inp2:ord_GetFormAction payment_type_id="$payment_type_id"/>">
								<inp2:ord_GetFormHiddenFields return_template="in-commerce/checkout/checkout_success"
															  cancel_template="in-commerce/checkout/billing"
															  payment_type_id="$payment_type_id"/>

								<inp2:m_if check="m_Param" name="submit_url" equals_to="https://checkout.google.com/api/checkout/v2">
									<input type="image" name="Google Checkout" alt="Fast checkout through Google"
							        	src="https://checkout.google.com/buttons/checkout.gif?merchant_id=<inp2:m_Param name="merchant_id"/>
							              &w=180&h=46&style=white&variant=text&loc=en_US" height="46" width="180">
								<inp2:m_else/>
									<input type="image" name="Google Checkout" alt="Fast checkout through Google"
							        src="http://sandbox.google.com/checkout/buttons/checkout.gif?merchant_id=<inp2:m_Param name="merchant_id"/>
							              &w=180&h=46&style=white&variant=text&loc=en_US" height="46" width="180">
								</inp2:m_if>
							</form>
						</inp2:m_DefineElement>

						<inp2:ord_DisplayPaymentGateway name="Google Checkout" render_as="google_checkout_button"/>
					</inp2:m_if>
				</inp2:m_if>
			</inp2:m_RenderElement>
		</div>

		<div class="movable-element">
			<inp2:m_if check="ord_CartIsEmpty">
				<inp2:m_include template="in-commerce/elements/content_boxes/pick_products.elm"/>
			</inp2:m_if>
		</div>
	</div>
</inp2:m_DefineElement>
<!--## /MAIN CONTENT ##-->

<!--## DESIGN TEMPLATE ##-->
<inp2:m_include template="platform/designs/default_design.des" pass_params="1"/>
<!--## /DESIGN TEMPLATE ##-->
