<?php
/**
* @version	$Id: coupon_items_config.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'coupi',
					'ItemClass'			=>	Array('class'=>'kDBItem','file'=>'','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'CouponItemsEventHandler','file'=>'coupon_items_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'CouponItemsTagProcessor','file'=>'coupon_items_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,
					'Hooks'	=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'p',
													'HookToSpecial' => '-item',
													'HookToEvent' => Array('OnAfterItemDelete'),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnDeleteCouponItem',
												),
											),
					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'page',
												3	=>	'event',
											),
					'IDField'			=>	'CouponItemId',
					'StatusField'		=>	Array('Status'),
					'TitleField'		=>	'Name',
					'TableName'			=>	TABLE_PREFIX.'ProductsCouponItems',

					'CalculatedFields'	=>	Array(
												''	=>	Array(
															'ProductId'		=>	'p.ProductId',
															'ItemName'			=>	'IF(p.Name IS NULL,c.Name,p.l1_Name)',
															'SKU'			=>	'p.SKU',
															'Weight'		=>	'p.Weight',
															'CreatedOn'		=>	'p.CreatedOn',
															'BackOrderDate'	=>	'p.BackOrderDate',
															'Status'		=>	'p.Status',
															'CategoryId'	=>	'c.CategoryId',

														),

											),
					'ListSQLs'			=>	Array(	''=>'	SELECT %1$s.* %2$s
															FROM %1$s
															LEFT JOIN '.TABLE_PREFIX.'Products p ON %1$s.ItemResourceId = p.ResourceId
															LEFT JOIN '.TABLE_PREFIX.'Category c ON %1$s.ItemResourceId = c.ResourceId',
																		), // key - special, value - list select sql
					'ItemSQLs'			=>	Array(	''=>'SELECT * FROM %s',
																		),

					/*'BelongsTo'			=> Array(
												Array('prefix' => 'd', 'key' => 'DiscountId', 'ForeignKey' => 'DiscountId'),
											),*/
					'ForeignKey'	=>	'CouponId',
					'ParentTableKey' => 'CouponId',
					'ParentPrefix' => 'coup',
					'AutoDelete'	=>	true,
					'AutoClone'	=> true,

					'ListSortings'	=> 	Array(
												'' => Array(
													'Sorting' => Array('ItemName' => 'asc'),
												)
											),

					'Fields' => Array (
						'CouponItemId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0, ),
			            'CouponId' => Array('type' => 'int', 'default' => 0, ),
			            'ItemResourceId' => Array('type' => 'int', 'default' => 0, ),
			            'ItemType' => Array('type' => 'int', 'not_null' => 1, 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array ( 1 => 'la_Product', 2 => 'la_Category', 0 => 'la_WholeOrder' ), 'default' => 1, ),
					),

					'VirtualFields'	=> 	Array(
													'ProductId' => Array(),
													'ItemName' => Array(),
													'SKU' => Array(),
													'Weight' => Array('type'=>'float', 'min_value_exc'=>0, 'formatter' => 'kFormatter', 'format' => '%0.2f'),
													'CreatedOn' => Array('formatter' => 'kDateFormatter', 'default'=>'#NOW#' ),
													'BackOrderDate' => Array('formatter' => 'kDateFormatter'),
												),

					'Grids'	=> Array(
								'Default'		=>	Array(
																	'Icons' => Array('default'=>'icon16_entire_order.gif'),
																	'Fields' => Array(
																			'ItemType' => Array( 'title'=>'la_col_ItemType', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_empty_filter'),
																		),

																),
								'CouponItems'		=>	Array(
																	'Icons' => Array('default'=>'icon16_custom.gif',1=>'icon16_product.gif',2=>'icon16_product_pending.gif',0=>'icon16_product_disabled.gif'),
																	'Fields' => Array(
																			'ProductId' => Array( 'title'=>'la_col_Id', 'data_block' => 'grid_item_td', 'filter_block' => 'grid_range_filter'),
																			'ItemName' => Array( 'title'=>'la_col_ItemName', 'filter_block' => 'grid_like_filter'),
																			'ItemType' => Array( 'title'=>'la_col_CouponItemType', 'filter_block' => 'grid_options_filter'),
																		),

																),
													),
	);

?>