<?php
/**
* @version	$Id: orders_config.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

$config	=	Array(
					'Prefix'			=>	'ord',
					'ItemClass'			=>	Array('class'=>'OrdersItem','file'=>'orders_item.php','build_event'=>'OnItemBuild'),
					'ListClass'			=>	Array('class'=>'kDBList','file'=>'','build_event'=>'OnListBuild'),
					'EventHandlerClass'	=>	Array('class'=>'OrdersEventHandler','file'=>'orders_event_handler.php','build_event'=>'OnBuild'),
					'TagProcessorClass' =>	Array('class'=>'OrdersTagProcessor','file'=>'orders_tag_processor.php','build_event'=>'OnBuild'),
					'AutoLoad'			=>	true,

					'Hooks'				=>	Array(
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'ord',
													'HookToSpecial' => '',
													'HookToEvent' => Array( 'OnPreSave' ),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnRecalculateItems',
												),

												/* OnApplyCoupon is called as hook for OnUpdateCart/OnCheckout, which calls OnRecalcualate themself
												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'coup',
													'HookToSpecial' => '',
													'HookToEvent' => Array( 'OnApplyCoupon' ),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnRecalculateItems',
												),*/

												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'u',
													'HookToSpecial' => '',
													'HookToEvent' => Array( 'OnCreate' ),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnUserCreate',
												),

												Array(
													'Mode' => hBEFORE,
													'Conditional' => false,
													'HookToPrefix' => 'u',
													'HookToSpecial' => '',
													'HookToEvent' => Array('OnCheckExpiredMembership'),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnCheckRecurringOrders',
												),

												Array(
													'Mode' => hAFTER,
													'Conditional' => false,
													'HookToPrefix' => 'u',
													'HookToSpecial' => '',
													'HookToEvent' => Array( 'OnLogin' ),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnUserLogin',
												),

												Array(
													'Mode' => hBEFORE, // before because OnInpLogin is called after real in-portal login and uses data from hooks
													'Conditional' => false,
													'HookToPrefix' => 'u',
													'HookToSpecial' => '',
													'HookToEvent' => Array( 'OnInpLogin' ),
													'DoPrefix' => '',
													'DoSpecial' => '',
													'DoEvent' => 'OnUserLogin',
												),
											),
					'AggregateTags' => Array(
															Array(
																'AggregateTo' => 'orditems',
																'AggregatedTagName' => 'LinkRemoveFromCart',
																'LocalTagName' => 'Orditems_LinkRemoveFromCart',
															),
															Array(
																'AggregateTo' => 'orditems',
																'AggregatedTagName' => 'ProductLink',
																'LocalTagName' => 'Orderitems_ProductLink',
															),
															Array(
																'AggregateTo' => 'orditems',
																'AggregatedTagName' => 'ProductExists',
																'LocalTagName' => 'Orderitems_ProductExists',
															),
													),

					'QueryString'		=>	Array(
												1	=>	'id',
												2	=>	'Page',
												3	=>	'event',
												4 	=>	'mode',
											),
					'IDField'			=>	'OrderId',
					'StatusField'		=>	Array('Status'),	// field, that is affected by Approve/Decline events

					'ViewMenuPhrase'	=>	'la_title_Orders',
					'CatalogTabIcon' => 'in-commerce:icon16_orders.gif',

					'TitleField' => 'OrderNumber',
					'TitlePresets'		=>	Array(
												'default'	=>	Array(	'new_status_labels'		=> Array('ord'=>'!la_title_Adding_Order!'),
																		'edit_status_labels'	=> Array('ord'=>'!la_title_Editing_Order!'),
																		'new_titlefield'		=> Array('ord'=>'!la_title_New_Order!'),
																),

												'orders_incomplete'	=>	Array(	'prefixes'				=>	Array('ord.incomplete_List'),
																				'format'				=>	"!la_title_IncompleteOrders!",
																),

												'orders_pending'	=>	Array(	'prefixes'				=>	Array('ord.pending_List'),
																				'format'				=>	"!la_title_PendingOrders!",
																),

												'orders_backorders'	=>	Array(	'prefixes'				=>	Array('ord.backorders_List'),
																				'format'				=>	"!la_title_BackOrders!",
																),

												'orders_toship'		=>	Array(	'prefixes'				=>	Array('ord.toship_List'),
																				'format'				=>	"!la_title_OrdersToShip!",
																),

												'orders_processed'	=>	Array(	'prefixes'				=>	Array('ord.processed_List'),
																				'format'				=>	"!la_title_OrdersProcessed!",
																),

												'orders_returns'	=>	Array(	'prefixes'				=>	Array('ord.returns_List'),
																				'format'				=>	"!la_title_OrdersReturns!",
																),

												'orders_denied'		=>	Array(	'prefixes'				=>	Array('ord.denied_List'),
																				'format'				=>	"!la_title_OrdersDenied!",
																),
												'orders_archived'	=>	Array(	'prefixes'				=>	Array('ord.archived_List'),
																				'format'				=>	"!la_title_OrdersArchived!",
																),

												'orders_search'		=>	Array(	'prefixes'				=>	Array('ord.search_List'),
																				'format'				=>	"!la_title_OrdersSearch!",
																),

												'orders_edit_general'	=>	Array('prefixes' => Array('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_General!"),
												'orders_edit_billing'	=>	Array('prefixes' => Array('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderBilling!"),
												'orders_edit_shipping'	=>	Array('prefixes' => Array('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderShipping!"),
												'orders_edit_items'		=>	Array('prefixes' => Array('ord', 'orditems_List'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderItems!"),
												'orders_edit_preview'	=>	Array('prefixes' => Array('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderPreview!"),

												'orders_gw_result' => Array('prefixes' => Array('ord'), 'format' => "!la_title_OrderGWResult!"),

												'order_items_edit'	=>	Array(	'prefixes'				=>	Array('ord', 'orditems'),
																				'new_status_labels'		=>	Array('orditems'=>'!la_title_Adding_Order_Item!'),
																				'edit_status_labels'	=>	Array('orditems'=>'!la_title_Editing_Order_Item!'),
																				'new_titlefield'		=>	Array('orditems'=>'!la_title_New_Order_Item!'),
																				'format'				=>	"#ord_status# '#ord_titlefield#' - #orditems_status# '#orditems_titlefield#'",
																		),

												'orders_export' =>  Array('format' => '!la_title_OrdersExport!'),

												'orders_product_edit'	=>	Array('format' => '!la_title_Editing_Order_Item!'),

											),

					'EditTabPresets' => Array (
						'Default' => Array (
							'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/orders/orders_edit', 'priority' => 1),
							'items' => Array ('title' => 'la_tab_Items', 't' => 'in-commerce/orders/orders_edit_items', 'priority' => 2),
							'shipping' => Array ('title' => 'la_tab_Shipping', 't' => 'in-commerce/orders/orders_edit_shipping', 'priority' => 3),
							'billing' => Array ('title' => 'la_tab_Billing', 't' => 'in-commerce/orders/orders_edit_billing', 'priority' => 4),
							'preview' => Array ('title' => 'la_tab_Preview', 't' => 'in-commerce/orders/orders_edit_preview', 'priority' => 5),
						),
					),

					'PermSection'		=>	Array('main' => 'in-commerce:orders'),


					'Sections'			=>	Array(
						'in-commerce:orders'	=>	Array(
								'parent'		=>	'in-commerce',
								'icon'			=>	'in-commerce:orders',
								'label'			=>	'la_tab_Orders',
								'url'			=>	Array('t' => 'in-commerce/orders/orders_pending_list', 'pass' => 'm'),
								'permissions'	=>	Array('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:deny', 'advanced:archive', 'advanced:place', 'advanced:process', 'advanced:ship', 'advanced:reset_to_pending'),
								'priority'		=>	1,
								'type'			=>	stTREE,
						),
					),

					'SectionAdjustments' => Array (
						'in-portal:visits' => Array (
							'url' => Array ('t' => 'in-commerce/visits/visits_list_incommerce', 'pass' => 'm'),
						),
					),

					'StatisticsInfo'	=>	Array(
													'pending'	=>	Array(
																			'icon'		=>	'icon16_orders.gif',
																			'label'		=>	'la_title_Orders',
																			'js_url' 	=>	"#url#",
																			'url'		=>	Array('t' => 'in-commerce/orders/orders_pending_list', 'pass' => 'm'),
																			'status'	=>	ORDER_STATUS_PENDING,
																	),
											),

					'TableName'			=>	TABLE_PREFIX.'Orders',

					'FilterMenu'		=>	Array(
												'Groups' => Array(
													Array('mode' => 'AND', 'filters' => Array(0,1,2,3,4,5,6), 'type' => WHERE_FILTER),
												),

												'Filters' => Array(
													0	=>	Array('label' => 'la_Incomplete', 'on_sql' => '', 'off_sql' => '%1$s.Status != 0' ),
													1	=>	Array('label' => 'la_Pending', 'on_sql' => '', 'off_sql' => '%1$s.Status != 1'  ),
													2	=>	Array('label' => 'la_BackOrders', 'on_sql' => '', 'off_sql' => '%1$s.Status != 2'  ),
													3	=>	Array('label' => 'la_ToShip', 'on_sql' => '', 'off_sql' => '%1$s.Status != 3' ),
													4	=>	Array('label' => 'la_Processed', 'on_sql' => '', 'off_sql' => '%1$s.Status != 4'  ),
													5	=>	Array('label' => 'la_Denied', 'on_sql' => '', 'off_sql' => '%1$s.Status != 5'  ),
													6	=>	Array('label' => 'la_Archived', 'on_sql' => '', 'off_sql' => '%1$s.Status != 6'  ),
												)
											),

					'CalculatedFields' => Array(
						'' => Array (
							'CustomerName'			=>	'IF( ISNULL(u.Login), IF (%1$s.PortalUserId = -1, \'root\', IF (%1$s.PortalUserId = -2, \'Guest\', \'n/a\')), CONCAT(u.FirstName,\' \',u.LastName) )',
							'Username'				=>	'IF( ISNULL(u.Login),\'root\',u.Login)',
							'OrderNumber'			=>	'CONCAT(LPAD(Number,6,"0"),\'-\',LPAD(SubNumber,3,"0") )',
							'SubtotalWithoutDiscount'	=>	'(SubTotal + DiscountTotal)',
							'SubtotalWithDiscount'	=>	'(SubTotal)',
							'AmountWithoutVAT'		=>	'(SubTotal+IF(ShippingTaxable=1, ShippingCost, 0)+IF(ProcessingTaxable=1, ProcessingFee, 0))',
							'TotalAmount'			=>	'ROUND(SubTotal+ShippingCost+VAT+ProcessingFee+InsuranceFee-GiftCertificateDiscount,2)',
							'CouponCode'			=>	'pc.Code',
							'CouponName'			=>	'pc.Name',
							'AffiliateUser'			=>	'IF( LENGTH(au.Login),au.Login,\'!la_None!\')',
							'AffiliatePortalUserId'	=>	'af.PortalUserId',
							'GiftCertificateCode'	=>	'gc.Code',
							'GiftCertificateRecipient' => 'gc.Recipient',
						),

						'myorders' => Array (
							'OrderNumber'			=>	'CONCAT(LPAD(Number,6,"0"),\'-\',LPAD(SubNumber,3,"0") )',
							'SubtotalWithoutDiscount'	=>	'(SubTotal + DiscountTotal)',
							'SubtotalWithDiscount'	=>	'(SubTotal)',
							'AmountWithoutVAT'		=>	'(SubTotal+IF(ShippingTaxable=1, ShippingCost, 0)+IF(ProcessingTaxable=1, ProcessingFee, 0))',
							'TotalAmount'			=>	'ROUND(SubTotal+ShippingCost+VAT+ProcessingFee+InsuranceFee-GiftCertificateDiscount,2)',
							/*'ItemsCount'			=>	'COUNT(%1$s.OrderId)',*/
						),
					),
					// %1$s - table name of object
					// %2$s - calculated fields
					'ListSQLs' => Array (
						'' => '	SELECT %1$s.* %2$s
								FROM %1$s
								LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId
								LEFT JOIN '.TABLE_PREFIX.'ProductsCoupons pc ON %1$s.CouponId = pc.CouponId
								LEFT JOIN '.TABLE_PREFIX.'GiftCertificates gc ON %1$s.GiftCertificateId = gc.GiftCertificateId
								LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
								LEFT JOIN '.TABLE_PREFIX.'PortalUser au ON af.PortalUserId = au.PortalUserId',

						'myorders' => '	SELECT %1$s.* %2$s
										FROM %1$s
										LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId',
//										LEFT JOIN '.TABLE_PREFIX.'OrderItems ON %1$s.OrderId = '.TABLE_PREFIX.'OrderItems.OrderId',
					),

					'ItemSQLs' => Array (
						'' => '	SELECT %1$s.* %2$s FROM %1$s
								LEFT JOIN '.TABLE_PREFIX.'PortalUser u ON %1$s.PortalUserId = u.PortalUserId
								LEFT JOIN '.TABLE_PREFIX.'ProductsCoupons pc ON %1$s.CouponId = pc.CouponId
								LEFT JOIN '.TABLE_PREFIX.'GiftCertificates gc ON %1$s.GiftCertificateId = gc.GiftCertificateId
								LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
								LEFT JOIN '.TABLE_PREFIX.'PortalUser au ON af.PortalUserId = au.PortalUserId',
					),

					'SubItems'	=> Array('orditems'),
					'ListSortings'	=> 	Array(
																'' => Array(
																	'Sorting' => Array('OrderDate' => 'desc'),
																)
															),
					'Fields' => Array(
							            'OrderId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0, 'filter_type' => 'equals'),
							            'Number' => Array('type' => 'int','required'=>1,'formatter'=>'kFormatter', 'unique'=>Array('SubNumber'),'format'=>'%06d', 'max_value_inc'>999999, 'not_null' => '1','default' => 0),
							            'SubNumber' => Array('type' => 'int','required'=>1,'formatter'=>'kFormatter','unique'=>Array('Number'), 'format'=>'%03d', 'max_value_inc'>999, 'not_null' => '1','default' => 0),
							            'Status' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter','options'=>Array(0=>'la_Incomplete',1=>'la_Pending',2=>'la_BackOrders',3=>'la_ToShip',4=>'la_Processed',5=>'la_Denied',6=>'la_Archived'), 'use_phrases'=>1, 'not_null' => '1','default' => 0, 'filter_type' => 'equals'),
										'OnHold' => Array (
											'type' => 'int',
											'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
											'not_null' => 1, 'default' => 0
										),
							            'OrderDate' => Array('type' => 'int', 'formatter'=>'kDateFormatter', 'required' => 1, 'not_null' => '1', 'default' => '#NOW#'),
							            'PortalUserId'=>Array('type'=>'int','formatter'=>'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options'=>Array(-1=>'root',-2=>'Guest'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PortalUser WHERE `%s` = \'%s\'','left_key_field'=>'PortalUserId','left_title_field'=>'Login','required'=>1,'not_null'=>1,'default'=>-1),
							            'OrderIP' => Array('type' => 'string','not_null' => '1','default' => '', 'filter_type' => 'like'),
							            'UserComment' => Array('type' => 'string', 'formatter' => 'kFormatter', 'not_null' => 1, 'using_fck' => 1, 'default' => ''),
							            'AdminComment' => Array('type' => 'string', 'formatter' => 'kFormatter', 'not_null' => 1, 'using_fck' => 1, 'default' => ''),
							            'BillingTo' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingCompany' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingPhone' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingFax' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingEmail' => Array('type' => 'string','formatter'=>'kFormatter', 'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i','not_null' => '1','default' => ''),
							            'BillingAddress1' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingAddress2' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingCity' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingState' => Array('type' => 'string', 'formatter'=>'kOptionsFormatter',
							            							'options' => Array(),
												            		'option_key_field'=>'DestAbbr','option_title_field'=>'Translation',
												            		'not_null' => '1','default' => ''),
							            'BillingZip' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'BillingCountry' => Array('type' => 'string', 'formatter'=>'kOptionsFormatter',
							            				'options_sql'=>'SELECT %1$s
																				FROM '.TABLE_PREFIX.'StdDestinations
																				LEFT JOIN '.TABLE_PREFIX.'Phrase
																					ON '.TABLE_PREFIX.'Phrase.Phrase = '.TABLE_PREFIX.'StdDestinations.DestName
																				WHERE
																					DestType=1
																					AND
																					LanguageId = %2$s
																				ORDER BY Translation',
												            		'option_key_field'=>'DestAbbr','option_title_field'=>'Translation',
												            		'not_null' => '1','default' => 'USA'),
							            'VAT' => Array('type' => 'float','formatter'=>'kFormatter','not_null'=>1,'default' => '0','format'=>'%01.2f'),
							            'VATPercent' => Array('type' => 'float','formatter'=>'kFormatter','not_null'=>1,'default' => '0','format'=>'%01.3f'),
							            'PaymentType' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter','options_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'PaymentTypes WHERE Status = 1', 'option_key_field'=>'PaymentTypeId','option_title_field'=>'Description', 'not_null' => 1, 'default' => 0),
							            'PaymentAccount' => Array('type' => 'string','not_null' => '1', 'cardtype_field' => 'PaymentCardType', 'default' => '', 'filter_type' => 'like'),
							            'PaymentNameOnCard' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'PaymentCCExpDate' => Array('type' => 'string', 'formatter'=>'kCCDateFormatter', 'month_field' => 'PaymentCCExpMonth', 'year_field'=>'PaymentCCExpYear', 'not_null' => '1','default' => ''),
							            'PaymentCardType' => Array('type' => 'string', 'not_null' => 1, 'formatter'=>'kOptionsFormatter', 'options' => Array('' => '','1' => 'Visa','2' => 'Mastercard', '3' => 'Amex', '4' => 'Discover', '5' => 'Diners Club', '6' => 'JBC'), 'default' => ''),
							            'PaymentExpires' => Array('type' => 'int', 'formatter'=>'kDateFormatter','not_null' => '1','default' => '#NOW#'),
							            'ShippingTo' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingCompany' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingPhone' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingFax' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingEmail' => Array('type' => 'string','formatter'=>'kFormatter', 'regexp'=>'/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i','not_null' => '1','default' => ''),
							            'ShippingAddress1' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingAddress2' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingCity' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingState' => Array('type' => 'string', 'formatter'=>'kOptionsFormatter',
							            							'options' => Array(),
												            		'option_key_field'=>'DestAbbr','option_title_field'=>'Translation',
												            		'not_null' => '1','default' => ''),
							            'ShippingZip' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingCountry' => Array('type' => 'string', 'formatter'=>'kOptionsFormatter',
							            				'options_sql'=>'SELECT %1$s
																				FROM '.TABLE_PREFIX.'StdDestinations
																				LEFT JOIN '.TABLE_PREFIX.'Phrase
																					ON '.TABLE_PREFIX.'Phrase.Phrase = '.TABLE_PREFIX.'StdDestinations.DestName
																				WHERE
																					DestType=1
																					AND
																					LanguageId = %2$s
																				ORDER BY Translation',
												            		'option_key_field'=>'DestAbbr','option_title_field'=>'Translation',
												           'not_null' => '1','default' => 'USA'),
							            'ShippingType' => Array('type' => 'int','formatter'=>'kOptionsFormatter','options_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'ShippingType WHERE Status = 1','option_key_field'=>'ShippingID','option_title_field'=>'Name', 'not_null' => 1, 'default' => 0),
							            'ShippingCost' => Array('type' => 'double','formatter'=>'kFormatter','format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
							            'ShippingCustomerAccount' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingTracking' => Array('type' => 'string','not_null' => '1','default' => ''),
							            'ShippingDate' => Array('type' => 'int', 'formatter'=>'kDateFormatter','default' => null),
							            'SubTotal' => Array('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
							            'ReturnTotal' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00'),
							            'CostTotal' => Array('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
							            'OriginalAmount'	=>	Array('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
							            'ShippingOption' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array(0 => 'la_ship_all_together', 1 => 'la_ship_backorder_separately', 2 => 'la_ship_backorders_upon_avail'), 'default'=>0),
							            'ShippingGroupOption' => Array('type' => 'int', 'not_null' => 1, 'formatter'=>'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array(0 => 'la_auto_group_shipments', 1 => 'la_manual_group_shipments'), 'default'=>0),
							            'GiftCertificateId' => Array('type' => 'int','default' => null),
							            'GiftCertificateDiscount' => Array('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00',),
							            'ShippingInfo' => Array('type' => 'string', 'default' => NULL),
							            'CouponId' => Array('type' => 'int','default' => null),
							            'CouponDiscount' => Array('type' => 'float','not_null' => '1','default' => '0.00','formatter'=>'kFormatter','format'=>'%01.2f'),
							            'DiscountTotal' => Array('type' => 'float','not_null' => '1','default' => '0.00','formatter'=>'kFormatter','format'=>'%01.2f'),
							            'TransactionStatus' => Array('type' => 'int', 'formatter'=>'kOptionsFormatter', 'options' => Array(0=>'la_Invalid', 1 => 'la_Verified', 2 => 'la_Penging'), 'use_phrases'=>1, 'not_null' => '1','default' => 2),
										'GWResult1' => Array('type' => 'string', 'formatter'=>'kSerializedFormatter', 'not_null' => '1','default' => ''),
							            'GWResult2' => Array('type' => 'string', 'formatter'=>'kSerializedFormatter', 'not_null' => '1','default' => ''),
							            'AffiliateId' => Array('type'=>'int','formatter'=>'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),  'options' => Array(0 => 'lu_None'),'left_sql'=>'SELECT %s FROM '.TABLE_PREFIX.'Affiliates af LEFT JOIN '.TABLE_PREFIX.'PortalUser pu ON pu.PortalUserId = af.PortalUserId WHERE `%s` = \'%s\'','left_key_field'=>'AffiliateId','left_title_field'=>'Login','not_null'=>1,'default'=>0),
							            'VisitId' => Array('type' => 'int', 'not_null' => 1, 'default' => 0),
            							'AffiliateCommission' => Array('type' => 'double', 'formatter'=>'kFormatter','format'=>'%.02f', 'not_null' => '1','default' => '0.0000'),
            							'ProcessingFee' => Array('type' => 'double', 'formatter'=>'kFormatter','format'=>'%.02f', 'not_null' => '0','default' => '0.0000'),
            							'InsuranceFee' => Array ('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
            							'ShippingTaxable'		=>	Array('type' => 'int', 'not_null' => 0, 'default' => 0),
            							'ProcessingTaxable'		=>	Array('type' => 'int', 'not_null' => 0, 'default' => 0),
            							'IsRecurringBilling'	=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
            							'ChargeOnNextApprove'	=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
            							'NextCharge'			=>	Array('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
            							'GroupId'			=>	Array('type' => 'int', 'not_null' => 1, 'default' => 0),
										'GoogleOrderNumber' => Array ('type' => 'string', 'default' => NULL), // MySQL BIGINT UNSIGNED = 8 Bytes, PHP int = 4 Bytes -> threat as string
							        ),

					'VirtualFields'	=> 	Array(
												'CustomerName'			=>	Array('type'=>'string','default'=>'','filter_type'=>'like'),
												'TotalAmount'			=>	Array('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
												'AmountWithoutVAT'		=>	Array('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
												'SubtotalWithDiscount'	=>	Array('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
												'SubtotalWithoutDiscount'	=>	Array('type' => 'float', 'formatter'=>'kFormatter', 'format'=>'%01.2f', 'not_null' => '1','default' => '0.00'),
												'OrderNumber'			=>	Array('type'=>'string','default'=>'', 'filter_type' => 'like'),

												// for ResetToUser
												'UserTo'		=>	Array('type'=>'string','default'=>''),
												'UserCompany'	=>	Array('type'=>'string','default'=>''),
												'UserPhone'		=>	Array('type'=>'string','default'=>''),
												'UserFax'		=>	Array('type'=>'string','default'=>''),
												'UserEmail'		=>	Array('type'=>'string','default'=>''),
												'UserAddress1'	=>	Array('type'=>'string','default'=>''),
												'UserAddress2'	=>	Array('type'=>'string','default'=>''),
												'UserCity'		=>	Array('type'=>'string','default'=>''),
												'UserState'		=>	Array('type'=>'string','default'=>''),
												'UserZip'		=>	Array('type'=>'string','default'=>''),
												'UserCountry'	=>	Array('type'=>'string','default'=>''),

												// for Search
												'Username'		=>	Array('type'=>'string','filter_type'=>'like'),
												'OrderSearchId' =>	Array('type'=>'int','filter_type'=>'equals','filter_field'=>'OrderId'),
												'FromDateTime'	=>	Array('formatter'=>'kDateFormatter','default'=>'','filter_type'=>'range_from','filter_field'=>'OrderDate' ),
												'ToDateTime'	=>	Array('formatter'=>'kDateFormatter','default'=>'','filter_type'=>'range_to','filter_field'=>'OrderDate', 'empty_time' => adodb_mktime(23,59,59) ),
												'FromAmount'	=>	Array('type'=>'double', 'formatter'=>'kFormatter', 'format'=>'%01.2f','filter_type'=>'range_from','filter_field'=>'TotalAmount'),
												'ToAmount'	=>	Array('type'=>'double', 'formatter'=>'kFormatter', 'format'=>'%01.2f','filter_type'=>'range_to','filter_field'=>'TotalAmount'),
												'HasBackOrders' => Array('default'=>false),
												'PaymentCVV2'	=>	Array('type'=>'string', 'default'=>false),
												'AffiliateUser' =>	Array('type'=>'string', 'filter_type' => 'like'),
												'AffiliatePortalUserId' => Array('type'=>'int'),

												// export related fields: begin
												'ExportFormat'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'CSV', /*2 => 'XML'*/), 'default' => 1),
												'ExportFilename'		=>	Array('type' => 'string', 'default' => ''),
												'FieldsSeparatedBy'		=>	Array('type' => 'string', 'default' => ','),
												'FieldsEnclosedBy'		=>	Array('type' => 'string', 'default' => '"'),
												'LineEndings'			=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'Windows', 2 => 'UNIX'), 'default' => 1),
												'LineEndingsInside'		=>	Array('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array(1 => 'CRLF', 2 => 'LF'), 'default' => 2),
												'IncludeFieldTitles'	=>	Array('type' => 'int', 'default' => 1),
												'ExportColumns'			=>	Array('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array()),
												'AvailableColumns'		=>	Array('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array()),
												'ExportPresets' => Array('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array()),
												'ExportSavePreset' =>	Array('type'=>'int'),
												'ExportPresetName' =>	Array('type'=>'string'),
												// export related fields: end
											),
					'Grids'	=> Array(
								'Default'		=>	Array(
															'Icons' => Array('default'=>'icon16_orders.gif', 0 => 'icon16_orders.gif', 1 => 'icon16_orders_pending.gif', 5 => 'icon16_orders_disabled.gif'),
															'Fields' => Array(
																			'OrderId'		=>	Array('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																			'OrderDate' => Array( 'title'=>'la_col_OrderDate', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_date_range_filter'),
																			'OrderNumber'	=> Array( 'title' => 'la_col_OrderNumber', 'data_block' => 'grid_ordernumber_td', 'filter_block' => 'grid_like_filter'),
																			'CustomerName'	=> Array( 'title' => 'la_col_CustomerName', 'data_block' => 'grid_userlink_td', 'user_field' => 'PortalUserId', 'filter_block' => 'grid_like_filter'),
																			'PaymentType'	=> Array( 'title' => 'la_col_PaymentType', 'data_block' => 'grid_billinglink_td', 'filter_block' => 'grid_options_filter'),
																			'TotalAmount'	=> Array( 'title' => 'la_col_TotalAmount', 'data_block' => 'grid_previewlink_td', 'filter_block' => 'grid_range_filter'),
																			'AffiliateUser'	=> Array( 'title' => 'la_col_AffiliateUser', 'data_block' => 'grid_userlink_td', 'user_field' => 'AffiliatePortalUserId', 'filter_block' => 'grid_like_filter'),
																			'OnHold' => Array ('title' => 'la_col_OnHold', 'filter_block' => 'grid_options_filter'),

																		),
													),
								'Search'		=>	Array(
															'Icons' => Array('default'=>'icon16_orders.gif', 0 => 'icon16_orders.gif', 1 => 'icon16_orders_pending.gif', 5 => 'icon16_orders_disabled.gif'),
															'Fields' => Array(
																			'OrderId'		=>	Array('title' => 'la_col_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
																			'OrderNumber'	=>	Array('title' => 'la_col_OrderNumber', 'data_block' => 'grid_ordernumber_td', 'filter_block' => 'grid_like_filter'),
																			'Status'		=>	Array('title' => 'la_col_Status', 'filter_block' => 'grid_options_filter', 'filter_block' => 'grid_options_filter'),
																			'OrderDate'	=>	Array('title' => 'la_col_OrderDate', 'filter_block' => 'grid_date_range_filter'),
																			'CustomerName'		=>	Array('title' => 'la_col_CustomerName', 'data_block' => 'grid_userlink_td', 'user_field' => 'PortalUserId', 'filter_block' => 'grid_like_filter'),
																			'PaymentType'	=> 	Array('title' => 'la_col_PaymentType', 'data_block' => 'grid_billinglink_td', 'filter_block' => 'grid_options_filter'),
																			'TotalAmount'	=>	Array('title' => 'la_col_TotalAmount', 'data_block' => 'grid_previewlink_td', 'filter_block' => 'grid_float_range_filter'),
																			'AffiliateUser'	=>	Array( 'title' => 'la_col_AffiliateUser', 'data_block' => 'grid_userlink_td', 'user_field' => 'AffiliatePortalUserId', 'filter_block' => 'grid_user_like_filter'),
																			'OrderIP'		=>	Array('title' => 'la_col_OrderIP', 'filter_block' => 'grid_like_filter'),
																			'Username'		=>	Array('title' => 'la_col_Username', 'filter_block' => 'grid_user_like_filter'),
																			'PaymentAccount'	=>	Array('title' => 'la_col_CreditCardNumber', 'filter_block' => 'grid_like_filter'),
																		),
													),
								),
	);

?>