<?php
/**
* @version	$Id: order_items_tag_processor.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

class OrderItemsTagProcessor extends kDBTagProcessor
{
	function PrintGrid($params)
	{

		$order =& $this->Application->recallObject('ord');
		if ($order->GetDBField('Status') != ORDER_STATUS_INCOMPLETE) {
			$params['grid'] = $params['NotEditable'];
		}
		else {
			$params['grid'] = $params['Editable'];
		}

		return $this->Application->ProcessParsedTag('m', 'ParseBlock', $params);
	}

	function IsTangible($params){
		$object =& $this->Application->recallObject( $this->getPrefixSpecial() );
		if ($object->GetDBField('Type') == 1)
			return true;
		else
			return false;
	}

	function HasQty($params)
	{
		$object =& $this->Application->recallObject( $this->getPrefixSpecial() );
		$type = $object->GetDBField('Type');
		return in_array($type, array(1,6));
	}

	function HasDiscount($params)
	{
		$object =& $this->Application->recallObject( $this->getPrefixSpecial() );
		return (float)$object->GetDBField('ItemDiscount') ? 1 : 0;
	}

	function HasOptions($params)
	{
		$object =& $this->getObject($params);
		$item_data = @unserialize($object->GetDBField('ItemData'));
		return isset($item_data['Options']);
	}

	function PrintOptions($params)
	{
		$object =& $this->getObject($params);
		$item_data = @unserialize($object->GetDBField('ItemData'));

		$render_as = $this->SelectParam($params, 'render_as');
		$block_params['name'] = $render_as;

		$opt_helper =& $this->Application->recallObject('kProductOptionsHelper');

		$o = '';
		$options = $item_data['Options'];
		foreach ($options as $opt => $val) {
			if (!is_array($val)) {
				$val = unhtmlentities($val);
			}
			$key_data = $opt_helper->ConvertKey($opt, $object->GetDBField('ProductId'));

			$parsed = $opt_helper->ExplodeOptionValues($key_data);
			if ($parsed) {
				$values = $parsed['Values'];
				$prices = $parsed['Prices'];
				$price_types = $parsed['PriceTypes'];
			}
			else {
				$values = array();
				$prices = array();
				$price_types = array();
			}

			$key = $key_data['Name'];
			/*if (is_array($val)) {
				$val = join(',', $val);
			}*/

			$lang =& $this->Application->recallObject('lang.current');

			if ($render_as) {
				$block_params['option'] = $key;
				if (is_array($val)) {
					$block_params['value'] = $val;
					$block_params['type'] = $key_data['OptionType'];
					$block_params['price'] = $prices;
					$block_params['price_type'] = $price_types;
				}
				else {
					$price_type = array_key_exists($val, $price_types) ? $price_types[$val] : '';
					$price = array_key_exists($val, $prices) ? $prices[$val] : '';

					if ($price_type == '$') {
						$iso = $this->GetISO($params['currency']);
						$value = $this->AddCurrencySymbol($lang->formatNumber($this->ConvertCurrency($price_type, $iso),2), $iso, true); // true to force sign
						$block_params['price'] = $value;
						$block_params['price_type'] = '';
						$block_params['sign'] = ''; // sign is included in the formatted value
					}
					else {
						$block_params['price'] = $price;
						$block_params['price_type'] = $price_type;
						$block_params['sign'] = $price >= 0 ? '+' : '-';
					}
					$block_params['value'] = htmlspecialchars($val);
					$block_params['type'] = $key_data['OptionType'];
				}
				$o.= $this->Application->ParseBlock($block_params, 1);
			}
			else {
				$o .= $key.': '.$val.'<br>';
			}
		}
		return $o;
	}

	function ProductsInStock($params)
	{
		$object =& $this->getObject($params);

		if (!$object->GetDBField('InventoryStatus')) {
			// unlimited count available
			return false;
		}

		if ($object->GetDBField('InventoryStatus') == 2) {
			$poc_table = $this->Application->getUnitOption('poc', 'TableName');
			$sql = 'SELECT QtyInStock
					FROM '.$poc_table.'
					WHERE (ProductId = '.$object->GetDBField('ProductId').') AND (Availability = 1) AND (CombinationCRC = '.$object->GetDBField('OptionsSalt').')';
			$ret = $this->Conn->GetOne($sql);
		}
		else {
			$ret = $object->GetDBField('QtyInStock');
		}

		return $ret;
	}

	function PrintOptionValues($params)
	{
		$block_params['name'] = $params['render_as'];

		$values = $this->Application->Parser->GetParam('value');
		$prices = $this->Application->Parser->GetParam('price');
		$price_types = $this->Application->Parser->GetParam('price_type');

		$o = '';
		$i = 0;
		foreach ($values as $val) {
			$i++;
			$val = unhtmlentities($val);
			$block_params['value'] = htmlspecialchars($val);
			if ($price_types[$val] == '$') {
				$iso = $this->GetISO($params['currency']);
				$value = $this->AddCurrencySymbol(sprintf("%.2f", $this->ConvertCurrency($prices[$val], $iso)), $iso, true); // true to force sign
				$block_params['price'] = $value;
				$block_params['price_type'] = '';
				$block_params['sign'] = ''; // sign is included in the formatted value
			}
			else {
				$block_params['price'] = $prices[$val];
				$block_params['price_type'] = $price_types[$val];
				$block_params['sign'] = $prices[$val] >= 0 ? '+' : '-';
			}
			$block_params['is_last'] = $i == count($values);
			$o.= $this->Application->ParseBlock($block_params, 1);
		}
		return $o;
	}

	/*function ConvertKey($key, &$object)
	{
		static $mapping = null;
		if (is_null($mapping) || !isset($mapping[$object->GetDBField('ProductId')])) {
			$table = TABLE_PREFIX.'ProductOptions';
			$sql = 'SELECT * FROM '.$table.' WHERE ProductId = '.$object->GetDBField('ProductId');
			$mapping[$object->GetDBField('ProductId')] = $this->Conn->Query($sql, 'ProductOptionId');
		}
		return $mapping[$object->GetDBField('ProductId')][$key];
	}*/

	function PrintList($params)
	{
		$list =& $this->GetList($params);
		$id_field = $this->Application->getUnitOption($this->Prefix, 'IDField');

		$list->Query();
		$o = '';
		$list->GoFirst();

		$block_params=$this->prepareTagParams($params);
		$block_params['name'] = $this->SelectParam($params, 'render_as,block');
		$block_params['pass_params'] = 'true';

		$product_object =& $this->Application->recallObject('p', 'p', Array('skip_autoload' => true));
		/* @var $product_object kCatDBItem */

		$product_id = $product_object->GetID();

		while (!$list->EOL()) {
			// load product used in orderitem
			$this->Application->SetVar( $this->getPrefixSpecial().'_id', $list->GetDBField($id_field) ); // for edit/delete links using GET
			$product_object->Load( $list->GetDBField('ProductId') );	// correct product load

			$this->Application->SetVar('m_cat_id', $product_object->GetDBField('CategoryId'));

			$o.= $this->Application->ParseBlock($block_params, 1);
			$list->GoNext();
		}

		// restore IDs used in cycle
		$this->Application->DeleteVar($this->getPrefixSpecial().'_id');
		$product_object->Load($product_id);

		return $o;
	}

	function DisplayOptionsPricing($params)
	{
		$object =& $this->getObject($params);
		if ($object->GetDBField('OptionsSelectionMode') == 1) {
			return false;
		}

		$item_data = unserialize($object->GetDBField('ItemData'));
		if (!is_array($item_data)) return false;
		$options = getArrayValue($item_data, 'Options');
		$helper =& $this->Application->recallObject('kProductOptionsHelper');
		$crc = $helper->OptionsSalt($options, true);

		$combs = $this->Conn->GetOne('SELECT COUNT(*) FROM '.TABLE_PREFIX.'ProductOptionCombinations WHERE CombinationCRC = '.$crc.' AND ProductId = '.$object->GetDBField('ProductId').' AND (Price != 0 OR (PriceType = 1 AND Price = 0))');
		return $combs == 0; // no overriding combinations found
	}
}