<?php
/**
* @version	$Id: multicards.php 11899 2009-07-14 11:11:59Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.net/license/commercial/ for copyright notices and details.
*/

	require_once GW_CLASS_PATH.'/gw_base.php';

	$class_name = 'kMultiCardsGW'; // for automatic installation

	class kMultiCardsGW extends kGWBase
	{

		function InstallData()
		{
			$data = array(
				'Gateway' => Array('Name' => 'Multicards', 'ClassName' => 'kMultiCardsGW', 'ClassFile' => 'multicards.php', 'RequireCCFields' => 0),
				'ConfigFields' => Array(
					'submit_url' => Array('Name' => 'Submit URL', 'Type' => 'text', 'ValueList' => '', 'Default' => 'https://secure.multicards.com/cgi-bin/order2/processorder1.pl'),
					'merchant_id' => Array('Name' => 'Merchant ID', 'Type' => 'text', 'ValueList' => '', 'Default' => ''),
					'merchant_url_idx' => Array('Name' => 'Merchant Order Page Id', 'Type' => 'text', 'ValueList' => '', 'Default' => ''),
				)
			);
			return $data;
		}

		/**
		 * Returns payment form submit url
		 *
		 * @param Array $gw_params gateway params from payment type config
		 * @return string
		 */
		function getFormAction($gw_params)
		{
			return $gw_params['submit_url'];
		}

		/**
		 * Processed input data and convets it to fields understandable by gateway
		 *
		 * @param Array $item_data
		 * @param Array $tag_params additional params for gateway passed through tag
		 * @param Array $gw_params gateway params from payment type config
		 * @return Array
		 */
		function getHiddenFields($item_data, $tag_params, $gw_params)
		{
			$ret = Array();

			$ret['mer_id'] = $gw_params['merchant_id'];
			$ret['mer_url_idx'] = $gw_params['merchant_url_idx'];

			$ret['num_items'] = 100;
			$ret['item1_price'] = $item_data['TotalAmount'];
			$ret['item1_desc'] = 'Order #'.$item_data['OrderNumber'];
			$ret['item1_qty'] = 1;


//			$ret['cancel_return'] = $this->Application->HREF($tag_params['cancel_template'],'',Array('pass'=>'m'));
//			$ret['return'] = $this->Application->HREF($tag_params['return_template'],'',Array('pass'=>'m'));
//			$ret['notify_url'] = $this->Application->BaseURL('/in-commerce').'gw_notify.php?sid='.$this->Application->GetSID().'&admin=1&order_id='.$item_data['OrderId'];
//			$ret['cmd'] = '_xclick'; // act as "Buy Now" PayPal button

			$ret['no_note'] = 1;	// customer is not prompted for notes
			$ret['no_shipping'] = 1;	// customer is not prompted for shipping address
			$ret['rm'] = 2;	// return method - POST
			$ret['currency_code'] = $target;
			$ret['invoice'] = $item_data['OrderNumber'];
			$ret['business'] = $gw_params['business_account'];

			// prepopulated fields
			$billing_email = $item_data['BillingEmail'];
			if (!$billing_email) {
				$billing_email = $this->Conn->GetOne('	SELECT Email FROM '.$this->Application->getUnitOption('u', 'TableName').'
											WHERE PortalUserId = '.$this->Application->RecallVar('user_id'));
			}
			$ret['cust_email'] = $billing_email;

			$ret['cust_name'] = $item_data['BillingTo'];
			$ret['cust_company'] = $item_data['BillingCompany'];
			$ret['cust_phone'] = $item_data['BillingPhone'];
			$ret['cust_address1'] = $item_data['BillingAddress1'];
			$ret['cust_address2'] = $item_data['BillingAddress2'];
			$ret['cust_city'] = $item_data['BillingCity'];
			$ret['cust_state'] = $item_data['BillingState'];
			$ret['cust_zip'] = $item_data['BillingZip'] ? $item_data['BillingZip'] : '99999';
//			$sql = 'SELECT DestAbbr2 FROM '.TABLE_PREFIX.'StdDestinations WHERE DestAbbr = %s';
//			$ret['country'] = $this->Conn->GetOne( sprintf($sql, $this->Conn->qstr($item_data['BillingCountry']) ) );
			$ret['cust_country'] = $item_data['BillingCountry'];

			$ret['user1'] = $this->Application->GetSID().','.MD5($item_data['OrderId']);

			$url = $this->Application->HREF($tag_params['return_template'], '', array('pass'=>'m'));
			$ret['user2'] = $url;

			return $ret;
		}

		function processNotification($gw_params)
		{
			$this->parsed_responce = $_POST;

			list ($sid, $auth_code) = explode(',', $this->Application->GetVar('user1'));
			$session =& $this->Application->recallObject('Session');
			$session->SID = $sid;

			$order_id = $this->Conn->GetOne('SELECT OrderId FROM '.TABLE_PREFIX.'Orders WHERE md5(OrderId) = '.$this->Conn->qstr($auth_code));
			$this->Application->SetVar('ord_id', $order_id);
			$order =& $this->Application->recallObject('ord');
			$order->Load($order_id);

			$url =  $this->Application->GetVar('user2');
			echo '<!--success--><a href="'.$url.'">'.$this->Application->Phrase('la_multicards_continue').'</a>';

			return 1;
		}
	}

?>