<?php
/**
* @version	$Id: product_options_tag_processor.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class ProductOptionsTagProcessor extends kDBTagProcessor {

	function ShowOptions($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		/** @var kProductOptionsHelper $opt_helper */
		$opt_helper = $this->Application->recallObject('kProductOptionsHelper');

		$parsed = $opt_helper->ExplodeOptionValues($object->GetFieldValues());
		if ( !$parsed ) {
			return '';
		}

		$values = $parsed['Values'];
		$conv_prices = $parsed['Prices'];
		$conv_price_types = $parsed['PriceTypes'];

		$options =& $this->GetOptions();

		$mode = $this->SelectParam($params, 'mode');
		$combination_prefix = $this->SelectParam($params, 'combination_prefix');
		$combination_field = $this->SelectParam($params, 'combination_field');

		if ( $mode == 'selected' ) {
			/** @var kDBItem $comb */
			$comb = $this->Application->recallObject($combination_prefix);

			$options = unserialize($comb->GetDBField($combination_field));
		}

		$block_params['name'] = $params['render_as'];
		$block_params['selected'] = '';
		$block_params['pass_params'] = 1;

		/** @var LanguagesItem $lang */
		$lang = $this->Application->recallObject('lang.current');

		$o = '';
		$first_selected = false;

		foreach ($values as $option) {
//			list($val, $label) = explode('|', $option);
			$val = $option;

			if ( getArrayValue($params, 'js') ) {
				$block_params['id'] = kUtil::escape($val, kUtil::ESCAPE_JS);
				$block_params['value'] = kUtil::escape($val);
			}
			else {
				$block_params['id'] = kUtil::escape($val);
				$block_params['value'] = kUtil::escape($val);
			}

			if ( $conv_prices[$val] ) {
				if ( $conv_price_types[$val] == '$' && !getArrayValue($params, 'js') && !getArrayValue($params, 'no_currency') ) {
					$iso = $this->GetISO($params['currency']);
					$value = sprintf("%.2f", $this->ConvertCurrency($conv_prices[$val], $iso));

					$value = $this->AddCurrencySymbol($lang->formatNumber($value, 2), $iso, true); // true to force sign
					$block_params['price'] = $value;
					$block_params['price_type'] = '';
					$block_params['sign'] = ''; //sign is included in the formatted value
				}
				else {
					$block_params['price'] = isset($params['js']) ? $conv_prices[$val] : $lang->formatNumber($conv_prices[$val], 2);
					$block_params['price_type'] = $conv_price_types[$val];
					$block_params['sign'] = $conv_prices[$val] >= 0 ? '+' : '-';
				}
			}
			else {
				$block_params['price'] = '';
				$block_params['price_type'] = '';
				$block_params['sign'] = '';
			}

			/*if ($mode == 'selected') {
				$selected = $combination[$object->GetID()] == $val;
			}
			else*/
			$selected = false;

			if ( !$options && isset($params['preselect_first']) && $params['preselect_first'] && !$first_selected ) {
				$selected = true;
				$first_selected = true;
			}

			if ( is_array($options) ) {
				$option_value = array_key_exists($object->GetID(), $options) ? $options[$object->GetID()] : '';

				if ( $object->GetDBField('OptionType') == OptionType::CHECKBOX ) {
					$selected = is_array($option_value) && in_array(kUtil::escape($val), $option_value);
				}
				else { // radio buttons ?
					// TODO: Not sure why we're unescaping.
					$selected = kUtil::unescape($option_value, kUtil::ESCAPE_HTML) == $val;
				}
			}

			if ( $selected ) {
				if ( $mode == 'selected' ) {
					if ( $object->GetDBField('OptionType') != OptionType::CHECKBOX ) {
						$block_params['selected'] = ' selected="selected" ';
					}
					else {
						$block_params['selected'] = ' checked="checked" ';
					}
				}
				else {
					switch ($object->GetDBField('OptionType')) {
						case OptionType::DROPDOWN:
							$block_params['selected'] = ' selected="selected" ';
							break;
						case OptionType::RADIO:
						case OptionType::CHECKBOX:
							$block_params['selected'] = ' checked="checked" ';
							break;
					}
				}
			}
			else {
				$block_params['selected'] = '';
			}

			$o .= $this->Application->ParseBlock($block_params);
		}

		return $o;
	}

	function &GetOptions()
	{
		$opt_data = $this->Application->GetVar('options');
		$options = getArrayValue($opt_data, $this->Application->GetVar('p_id'));
		if (!$options && $this->Application->GetVar('orditems_id')) {
			/** @var kDBItem $ord_item */
			$ord_item = $this->Application->recallObject('orditems.-opt', null, Array ('skip_autoload' => true));

			$ord_item->Load($this->Application->GetVar('orditems_id'));
			$item_data = unserialize($ord_item->GetDBField('ItemData'));
			$options = getArrayValue($item_data, 'Options');
		}
		return $options;
	}

	function OptionData($params)
	{
		/** @var kDBItem $object */
		$object = $this->getObject($params);

		$options =& $this->GetOptions();

		return getArrayValue($options, $object->GetID());
	}

	function ListOptions($params)
	{
		return $this->PrintList2($params);
	}
}
