<?php
/**
* @version	$Id: coupons_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'coup',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'CouponsEventHandler', 'file' => 'coupons_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'CouponsTagProcessor', 'file' => 'coupons_tag_processor.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'CouponId',
	'StatusField' => Array ('Status'),
	'TitleField' => 'Name',
	'TableName' => TABLE_PREFIX.'ProductsCoupons',
	'SubItems' => Array ('coupi'),

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('coup' => '!la_title_Adding_Coupon!'),
			'edit_status_labels' => Array ('coup' => '!la_title_Editing_Coupon!'),
			'new_titlefield' => Array ('coup' => '!la_title_New_Coupon!'),
		),

		'coupons_list' => Array (
			'prefixes' => Array ('coup_List'), 'format' => "!la_title_Coupons!",
		),

		'coupons_edit' => Array (
			'prefixes' => Array ('coup'),
			'format' => "#coup_status# '#coup_titlefield#' - !la_title_General!",
		),

		'coupons_items' => Array (
			'prefixes' => Array ('coup', 'coupi_List'),
			'format' => "#coup_status# '#coup_titlefield#' - !la_title_CouponItems!",
		),

		'coupons_clone' => Array (
			'prefixes' => Array ('coup'), 'format' => "!la_CloneCoupon!",
		),

		'coupon_selector' => Array ('format' => '!la_title_CouponSelector!'),
	),

	'EditTabPresets' => Array (
		'Default' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/discounts/coupon_edit', 'priority' => 1),
			'items' => Array ('title' => 'la_tab_CouponsItems', 't' => 'in-commerce/discounts/coupon_items', 'priority' => 2),
		),
	),

	'PermSection' => Array ('main' => 'in-commerce:coupons'),

	'Sections' => Array (
		'in-commerce:coupons' => Array (
			'parent' => 'in-commerce:discounts_folder',
			'icon' => 'discounts_coupons',
			'label' => 'la_tab_Coupons',
			'url' => Array ('t' => 'in-commerce/discounts/coupons_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:decline'),
			'priority' => 3.2, // <parent_priority>.<own_priority>, because this section replaces parent in tree
			'type' => stTAB,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Name' => 'asc'),
		)
	),

	'Fields' => Array (
		'CouponId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'Status' => Array (
				'type' => 'int', 'formatter' => 'kOptionsFormatter',
				'options' => Array ( 1 => 'la_Enabled', 2 => 'la_Used', 0 => 'la_Disabled' ),
				'use_phrases' => 1, 'not_null' => 1, 'default' => 1
		),
		'Name' => Array ( 'type' =>'string', 'required' => 1, 'default' => null, 'max_len' => 255),
		'Code' => Array (
				'type' => 'string', 'required' => 1, 'default' => null,
				'max_len' => 255, 'unique' => Array ('Code'),
		),
		'Expiration' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null,),
		'GroupId' => Array ('type' => 'int', 'default' => null, ),
		'Type' => Array (
				'type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
				'options' => Array ( 1 => 'la_Flat', 2 => 'la_Percent'/*, 3 => 'la_FreeShipping'*/),
				'not_null' => 1, 'default' => 1,
		 ),
		'Amount' => Array ('type' => 'double', 'default' => null),
		'LastUsedBy' => Array (
			'type' => 'int',
			'formatter' => 'kLEFTFormatter',
			'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
			'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
			'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users WHERE %s',
			'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD,
			'required' => 0, 'default' => null,
		),
		'LastUsedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		'NumberOfUses' => Array ('type' => 'int', 'default' => 1),
	),

	'VirtualFields' => Array (
		'CouponCount' => Array ('type' => 'int', 'min_value_inc' => 1, 'default' => 1),
		'DefaultExpiration' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				0 => 'icon16_disabled.png',
				1 => 'icon16_item.png',
				2 => 'icon16_pending.png',
				'module' => 'core',
			),
			'Fields' => Array (
				'CouponId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
				'Name' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'Code' => Array ('title' => 'column:la_fld_CouponCode', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Expiration' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
				'Type' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
				'Amount' => Array ('filter_block' => 'grid_range_filter', 'width' => 100, ),
				'LastUsedBy' => Array ('filter_block' => 'grid_like_filter', 'width' => 140, ),
				'LastUsedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 140, ),
				'NumberOfUses' => Array ('filter_block' => 'grid_range_filter', 'width' => 130, ),
			),
		),
		'Radio' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				0 => 'icon16_disabled.png',
				1 => 'icon16_item.png',
				2 => 'icon16_pending.png',
				'module' => 'core',
			),
			'Selector' => 'radio',
			'Fields' => Array (
				'CouponId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
				'Name' => Array ('filter_block' => 'grid_like_filter', 'width' => 150, ),
				'Code' => Array ('title' => 'column:la_fld_CouponCode', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Expiration' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 145, ),
				'Type' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
				'Amount' => Array ('filter_block' => 'grid_range_filter', 'width' => 100, ),
				'LastUsedBy' => Array ('filter_block' => 'grid_like_filter', 'width' => 140, ),
				'LastUsedOn' => Array ('filter_block' => 'grid_date_range_filter', 'width' => 140, ),
				'NumberOfUses' => Array ('filter_block' => 'grid_range_filter', 'width' => 130, ),
			),
		),
	),
);
