<?php
/**
* @version	$Id: affiliate_plans_event_handler.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class AffiliatePlansEventHandler extends kDBEventHandler {

		/**
		 * Apply any custom changes to list's sql query
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 * @see kDBEventHandler::OnListBuild()
		 */
		protected function SetCustomQuery(kEvent $event)
		{
			parent::SetCustomQuery($event);

			if ( $event->Special == 'active' ) {
				/** @var kDBList $object */
				$object = $event->getObject();

				$object->addFilter('active', '%1$s.Enabled = 1');
			}
		}

		/**
		 * Enter description here...
		 *
		 * @param kEvent $event
		 */
		function OnSetPrimary($event)
		{
			$object = $event->getObject();
			$object->SetDBField('IsPrimary', 1);
			$object->Update();
		}

		/**
		 * Occurs before updating item
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemUpdate(kEvent $event)
		{
			parent::OnBeforeItemUpdate($event);

			$this->itemChanged($event);
		}

		/**
		 * Occurs before creating item
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnBeforeItemCreate(kEvent $event)
		{
			parent::OnBeforeItemCreate($event);

			$this->itemChanged($event);
		}

		/**
		 * Occurs before item is changed
		 *
		 * @param kEvent $event
		 */
		function itemChanged($event)
		{
			/** @var kDBItem $object */
			$object = $event->getObject();

			$live_table = $this->Application->getUnitOption($event->Prefix, 'TableName');
			$plans_count = $this->Conn->GetOne('SELECT COUNT(*) FROM ' . $live_table);
			if ( !$plans_count ) {
				$object->SetDBField('IsPrimary', 1);
			}

			if ( $object->GetDBField('IsPrimary') && $object->Validate() ) {
				$sql = 'UPDATE ' . $this->Application->getUnitOption($event->Prefix, 'TableName') . '
						SET IsPrimary = 0';
				$this->Conn->Query($sql);

				$object->SetDBField($object->getStatusField(), 1);
			}
		}

		/**
		 * Don't allow to delete primary affiliate plan
		 *
		 * @param kEvent $event
		 * @param string $type
		 * @return void
		 * @access protected
		 */
		protected function customProcessing(kEvent $event, $type)
		{
			if ( $event->Name == 'OnMassDelete' && $type == 'before' ) {
				$ids = $event->getEventParam('ids');

				$sql = 'SELECT ' . $this->Application->getUnitOption($event->Prefix, 'IDField') . '
						FROM ' . $this->Application->getUnitOption($event->Prefix, 'TableName') . '
						WHERE IsPrimary = 1';
				$primary_id = $this->Conn->GetOne($sql);

				$ids = array_diff($ids, Array ($primary_id));

				$event->setEventParam('ids', $ids);
			}
		}
	}