<?php
/**
* @version	$Id: affiliate_payment_types_tp.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2011 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class AffiliatePaymentTypeTagProcessor extends kDBTagProcessor {

	/**
	 * Checks, that current affiliate payment type matches the one, being printed via PrintList tag
	 *
	 * @param $params
	 * @return bool
	 * @see kDBTagProcessor::PrintList()
	 * @access protected
	 */
	protected function Checked($params)
	{
		static $checked = false;

		/** @var kDBItem $affiliate */
		$affiliate = $this->Application->recallObject( $params['prefix'] );

		$payment_type = $affiliate->GetDBField( $params['field'] );

		if ( $payment_type ) {
			/** @var kDBList $object */
			$object = $this->getObject($params);

			return $payment_type == $object->GetID();
		}

		if ( !$checked ) {
			// make first listed affiliate payment type selected
			$checked = true;

			return true;
		}

		return false;
	}
}