<?php
/**
* @version	$Id: pricing_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'pr',
	'ItemClass' => Array ('class'=> 'kDBItem', 'file'=> '', 'build_event'=> 'OnItemBuild'),
	'ListClass' => Array ('class'=> 'kDBList', 'file'=> '', 'build_event'=> 'OnListBuild'),
	'EventHandlerClass' => Array ('class'=> 'PricingEventHandler', 'file'=> 'pricing_event_handler.php', 'build_event'=> 'OnBuild'),
	'TagProcessorClass' => Array ('class'=> 'PricingTagProcessor', 'file'=> 'pricing_tag_processor.php', 'build_event'=> 'OnBuild'),

	'AutoLoad' => true,

	'Hooks' => Array (
		// for tangible products: pricings are always aranged before saveing product
		Array (
			'Mode' => hBEFORE,
			'Conditional' => true,
			'HookToPrefix' => '#PARENT#',
			'HookToSpecial' => '',
			'HookToEvent' => Array ('OnPreSave'),
			'DoPrefix' => '',
			'DoSpecial' => 'tang',
			'DoEvent' => 'OnArrange',
		),
	),

	'AggregateTags' => Array (
		Array (
			'AggregateTo' => '#PARENT#',
			'AggregatedTagName' => 'Price',
			'LocalTagName' => 'ProductPrice',
		),
		Array (
			'AggregateTo' => '#PARENT#',
			'AggregatedTagName' => 'ListPriceBrackets',
			'LocalTagName' => 'Product_ListPriceBrackets',
		),
		Array (
			'AggregateTo' => '#PARENT#',
			'AggregatedTagName' => 'HasQuantityPricing',
			'LocalTagName' => 'Product_HasQuantityPricing',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
	),

	'StatusField' => Array ('IsPrimary'),
	'IDField' => 'PriceId',
	'TableName' => TABLE_PREFIX.'ProductsPricing',

	'ForeignKey' => 'ProductId',
	'ParentTableKey' => 'ProductId',
	'ParentPrefix' => 'p',
	'AutoDelete' => true,
	'AutoClone' => true,

	'ListSQLs' => Array (
		''=> '	SELECT *
				FROM %s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('MinQty' => 'asc'),
		)
	),

	'Fields' => Array (
		'PriceId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
		'ProductId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'MinQty' => Array ('type' => 'int', 'default' => null),
		'MaxQty' => Array ('type' => 'int', 'default' => null),
		'Cost' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%.2f', 'default' => 0),
		'Price' => Array ('type' => 'float', 'not_null' => 1, 'formatter' => 'kFormatter', 'min_value_inc' => 0, 'format' => '%.2f', 'default' => 0),
		'Negotiated' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array ( 0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,
			'default' => NULL,
		),
		'Points' => Array ('type' => 'int', 'default' => null),
		'AccessDuration'=>	Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
		'AccessUnit' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' => Array (1 => 'la_opt_sec', 2 => 'la_opt_min', 3 => 'la_opt_hour', 4 => 'la_opt_day', 5 => 'la_opt_week', 6 => 'la_opt_month', 7 => 'la_opt_year'), 'not_null' => 1, 'default' => 0,),
		'Description' => Array ('type' => 'string', 'max_len' => 255, 'default' => NULL),
		'IsPrimary' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array ( 0 => 'la_No', 1 => 'la_Yes', ), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'GroupId' => Array ('type' => 'int', 'default' => 0, 'not_null' => 1),

		/* TODO implement these fields in business logic
		'AccessRebillDate' => Array (
			'type'=> 'int', 'min_value' => 0, 'max_value' => 31, 'not_null'=> '1', 'default' => 0,
		),
		'DurationType' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (
				1 => 'la_opt_Interval', 2 => 'la_opt_Date',
			),
			'use_phrases' => 1, 'not_null' => 1, 'default' => 1,
		),
		'AccessExpiration' => Array ('type' => 'int', 'formatter' => 'kDateFormatter'),
		*/
	),

	'Grids' => array(
		'Access' => array(
			'Icons' => array(
				'default' => 'icon16_item.png',
				'0' => 'icon16_item.png',
				'1' => 'icon16_primary.png',
				'module' => 'core',
			),
			'Fields' => array(
				'AccessDuration' => array('data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
				'AccessUnit' => array('title' => 'column:la_fld_AccessDurationUnit', 'filter_block' => 'grid_options_filter'),
				'Description' => array('filter_block' => 'grid_like_filter'),
				'Price' => array('filter_block' => 'grid_range_filter'),
			),
		),
	),
);
