<?php
/**
* @version	$Id: rightconnect.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	require_once GW_CLASS_PATH.'/gw_base.php';

	class kGWRightConnect extends kGWBase
	{

	/*	function Install()
		{
			$query = "INSERT INTO `".TABLE_PREFIX."Gateways` ( `GatewayId` , `Name` , `ClassName` , `ClassFile` , `RequireCCFields` )
								VALUES (
									'', 'RightConnect', 'kGWRightConnect', 'rightconnect.php', '1'
								)";
			$this->Conn->Query($query);
			$id = $this->Conn->getInsertID();

			$query = "INSERT INTO `".TABLE_PREFIX."GatewayConfigFields` ( `GWConfigFieldId` , `SystemFieldName` , `FieldName` , `ElementType` , `ValueList` , `GatewayId` )
								VALUES (
								'', 'submit_url', 'Submit URL', 'text', '', '$id'
								), (
								'', 'user_account', 'User Account', 'text', '', '$id'
								), (
								'', 'password', 'User Account', 'text', '', '$id'
								),
								(
								'', 'encapsulate_char', 'Encapsualte Char', 'text', '', '$id'
								)";
			$this->Conn->Query($query);
		}*/

		function DirectPayment($item_data, $gw_params)
		{

			/*$post_fields["card_holder"] = "test test";
			$post_fields["cardtype"] = "Visa";
			$post_fields["card_number"] = "4444333322221111";
			$post_fields["cvv2"] = "123";
			$post_fields["exp_mon"] = "05";
			$post_fields["exp_year"] = "05";
			$post_fields["address1"] = "test";
			$post_fields["city"] = "test";
			$post_fields["state"] = "CA";
			$post_fields["zip"] = "90069";
			$post_fields["country"] = "USA";
			$post_fields["firstname"] = "test";
			$post_fields["lastname"] = "test";
			$post_fields["email"] = "customer@yourdomain.com";
			$post_fields["merchant_account"] = "demo";
			$post_fields["trans_amount"] = "8.98";
			$post_fields["user1"] = "DELIM";
			$post_fields["ALIAS"] = "www.yourdomain.com";
			$post_fields["customer_ip"] = $this->Application->getClientIp();
			$post_fields["ADMIN_EMAIL"] = "admin@yourdomain.com";*/


			$post_fields = Array();
			// -- Login Information --
			//$post_fields['x_version']			=	'3.1';
			$post_fields["user1"] = "DELIM";

			//$post_fields['x_type']				=	$gw_params['shipping_control'] == SHIPPING_CONTROL_PREAUTH ? 'AUTH_ONLY' : 'AUTH_CAPTURE';

			$post_fields['merchant_account']	=	$gw_params['user_account'];
			$post_fields['merchant_pass']			=	$gw_params['password'];

			if( $this->IsTestMode() ) $post_fields['x_test_request'] = 'True';

			// -- Payment Details --
			$names = explode(' ', $item_data['BillingTo'], 2);
			$post_fields['firstname']		=	getArrayValue($names, 0);
			$post_fields['lastname']			=	getArrayValue($names, 1);
			$post_fields['trans_amount']			=	sprintf('%.2f', $item_data['TotalAmount']);

			//$post_fields['x_company']			=	$item_data['BillingCompany'];

			$post_fields['card_number']			=	$item_data['PaymentAccount'];
			$post_fields['card_holder']			=	$item_data['PaymentNameOnCard'];
			$post_fields['cvv2']			=	$item_data['PaymentCVV2'];

			list($exp_mon,$exp_year) = explode('/', $item_data['PaymentCCExpDate']);
			$post_fields['exp_mon']			=	$exp_mon;
			$post_fields['exp_year']			=	$exp_year;

			$post_fields['address1']			=	$item_data['BillingAddress1'];
			$post_fields['address2']			=	$item_data['BillingAddress2'];
			$post_fields['city']				=	$item_data['BillingCity'];
			$post_fields['state']				=	$item_data['BillingState'];
			$post_fields['zip']				=	$item_data['BillingZip'];

			$post_fields['country']			=	$item_data['BillingCountry'];

			$post_fields['user2']			=	$item_data['PortalUserId'];
			$post_fields['user3']		=	$item_data['OrderNumber'];
			$post_fields['customer_email']	=	'FALSE';

			$post_fields['customer_addr'] = $item_data['OrderIP']; // according to fields list in doc
			$post_fields['customer_ip'] = $item_data['OrderIP']; // according to example from doc
			$post_fields["email"] = $item_data['BillingEmail'];
			$post_fields["ADMIN_EMAIL"] = $this->Application->ConfigValue('DefaultEmailSender');

			/** @var kCurlHelper $curl_helper */
			$curl_helper = $this->Application->recallObject('CurlHelper');

			$curl_helper->SetPostData($post_fields);
			$this->gw_responce = $curl_helper->Send($gw_params['submit_url']);

			$gw_responce = $this->parseGWResponce(null, $gw_params);

			// gw_error_msg: $gw_response['responce_reason_text']
			// gw_error_code: $gw_response['responce_reason_code']
			return ($gw_responce['responce_code'] != 1) ? false : true;
		}

		/**
		 * Captures Authorized transaction by transaction ID
		 *
		 * @param Array $item_data
		 * @param Array $gw_params
		 * @return bool
		 */
		function Charge($item_data, $gw_params)
		{
			return true;
		}

		/**
		 * Parse previosly saved gw responce into associative array
		 *
		 * @param string $gw_responce
		 * @param Array $gw_params
		 * @return Array
		 */
		function parseGWResponce($gw_responce = null, $gw_params)
		{
			if( !isset($gw_responce) ) $gw_responce = $this->gw_responce;

			$fields = Array(
							'responce_code',  				// 0
							'responce_sub_code',			// 1
							'responce_reason_code',		// 2
							'responce_reason_text',		// 3
							'approval_code',					// 4
							'avs_result_code',				// 5
							'transaction_id',					// 6
							'fraud_score',						// 7
							'not_used8',							// 8
							'amount',									// 9
							'not_used10',							// 10
							'transaction_type',				// 11
							'not_used_customer_id',		// 12
							'first_name',							// 13
							'last_name',							// 14
							'not_documented_empty_field', // 15 !!!!!!!!!!! DOES NOT MATCH DOCUMENTATION
							'address',								// 16
							'city',										// 17
							'state',									// 18
							'zip',										// 19
							'country',								// 20
							'phone',									// 21
							'fax',										// 22
							'email',									// 23
							'ship_name',							// 24
							'not_used25',							// 25
							'not_used26',							// 26
							'ship_address',						// 27
							'ship_city',							// 28
							'ship_state',							// 29
							'ship_zip',								// 30
							'ship_country',						// 31
							'tax',										// 32
							'not_used32',							// 33
							'not_used33',							// 34
							'not_used34',							// 35
							'not_used35',							// 36
							'not_used36',							// 37
							'cvv_responce',						// 38
							'receipt_number',					// 39
							'passthru1',							// 40
							'passthru2',							// 41
							'passthru3',							// 42
							'passthru4',							// 43
							'passthru5',							// 44
							'passthru6',							// 45
							'passthru7',							// 46
							'passthru8',							// 47
							'passthru9',							// 48
							'passthru10',							// 49
							);

			$encapsulate_char = $gw_params['encapsulate_char'];
			if($encapsulate_char)
			{
				$ec_length = strlen($encapsulate_char);
				$gw_responce = substr($gw_responce, $ec_length, $ec_length * -1);
			}

			$gw_responce = explode($encapsulate_char.','.$encapsulate_char, $gw_responce);
			$ret = Array();
			foreach($fields as $field_index => $field_name)
			{
				$ret[$field_name] = $gw_responce[$field_index];
				unset($gw_responce[$field_index]);
			}
			$this->parsed_responce = $ret;
			return kUtil::array_merge_recursive($ret, $gw_responce); // returns unparsed fields with they original indexes together with parsed ones
		}

		function getGWResponce()
		{
			return serialize($this->parsed_responce);
		}

	}