<?php
/**
* @version	$Id: dst_event_handler.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class DstEventHandler extends kDBEventHandler {

	/**
	 * Creates item from submit data
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnCreate(kEvent $event)
	{
		/** @var kDBItem $object */
		$object = $event->getObject(Array ('skip_autoload' => true));

		// creates multiple db records from single request (OnCreate event only creates 1 record)
		$items_info = $this->Application->GetVar($event->getPrefixSpecial(true));

		if ( !$items_info ) {
			return;
		}

		foreach ($items_info as $field_values) {
			$object->setID(0);
			$object->SetFieldsFromHash($field_values);
			$event->setEventParam('form_data', $field_values);
			$this->customProcessing($event, 'before');

			if ( $object->Create() ) {
				$this->customProcessing($event, 'after');
				$event->status = kEvent::erSUCCESS;
			}
			else {
				$event->status = kEvent::erFAIL;
				$event->redirect = false;
				$this->Application->SetVar($event->getPrefixSpecial() . '_SaveEvent', 'OnCreate');
				$object->setID(0);
			}
		}
	}

	/**
	 * Apply custom processing to item
	 *
	 * @param kEvent $event
	 * @param string $type
	 * @return void
	 * @access protected
	 */
	protected function customProcessing(kEvent $event, $type)
	{
		if ( $type != 'before' ) {
			return;
		}

		/** @var kDBItem $object */
		$object = $event->getObject();

		$events = $this->Application->GetVar('events');

		if ( $events['z'] == 'OnUpdate' ) {
			$object->SetDBField('ShippingZoneId', $this->Application->GetVar('z_id'));
		}

		/** @var kDBItem $zone_object */
		$zone_object = $this->Application->recallObject('z');

		if ( $zone_object->GetDBField('Type') == 3 ) {
			$object->SetDBField('StdDestId', $this->Application->GetVar('ZIPCountry'));
		}
	}

	 /**
	 *
	 *
	 * @param kEvent $event
	 */
	function OnZoneUpdate($event) {

		/** @var kDBItem $object */
		$object = $event->getObject();

		/** @var kDBItem $zone_object */
		$zone_object = $this->Application->recallObject('z');

		$zone_id = (int)$zone_object->GetID();
		$zone_type = $zone_object->GetDBField('Type');

		$delete_zones_sql = 'DELETE FROM '.$object->TableName.' WHERE ShippingZoneId = '.$zone_id;
		$this->Conn->Query($delete_zones_sql);

		if ($zone_id != 0){
			$delete_zones_sql = 'DELETE FROM '.$object->TableName.' WHERE ShippingZoneId = 0';
			$this->Conn->Query($delete_zones_sql);
		}

		$selected_destinations = $this->Application->GetVar('selected_destinations');
		$selected_destinations_array = explode(',', $selected_destinations);
		$selected_destinations_array = array_unique($selected_destinations_array);
		foreach ($selected_destinations_array as $key => $dest_id) {

					if ($zone_object->GetDBField('Type') == 3){
						list ($zone_dest_id, $dest_value) = explode('|', $dest_id);
						$dest_id = $this->Application->GetVar('CountrySelector');
					}
					else {
						$dest_value = '';
					}

					if ($dest_id > 0){
						$object->SetDBField('ShippingZoneId', $zone_id);
						$object->SetDBField('StdDestId', $dest_id);
						$object->SetDBField('DestValue', $dest_value);
						$object->Create();
					}

		}


	}

}
