<?php
/**
* @version	$Id: affiliate_payments_event_handler.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

	defined('FULL_PATH') or die('restricted access!');

	class AffiliatePaymentsEventHandler extends kDBEventHandler {

		/**
		 * Apply some special processing to object being
		 * recalled before using it in other events that
		 * call prepareObject
		 *
		 * @param kDBItem|kDBList $object
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function prepareObject(&$object, kEvent $event)
		{
			if ( $event->Special == 'log' ) {
				return ;
			}

			$parent_info = $object->getLinkedInfo();

			/** @var kDBItem $parent_object */
			$parent_object = $this->Application->recallObject($parent_info['ParentPrefix']);

			$options = $object->GetFieldOptions('PaymentTypeId');

			if ( $parent_object->isLoaded() ) {
				$options['default'] = $parent_object->GetDBField('PaymentTypeId');
				$object->SetDBField('PaymentTypeId', $parent_object->GetDBField('PaymentTypeId'));
			}

			if ( $this->Application->GetVar($event->getPrefixSpecial() . '_event') != 'OnNew' && $this->Application->GetVar($event->getPrefixSpecial() . '_event') != 'OnCreate' ) {
				$options['options'][0] = '';
			}

			$object->setFieldOptions('PaymentTypeId', $options);
		}

		/**
		 * Set's fields based on affiliate currently being edited
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnNew(kEvent $event)
		{
			parent::OnNew($event);

			/** @var kDBItem $affiliate */
			$affiliate = $this->Application->recallObject('affil');

			/** @var kDBItem $object */
			$object = $event->getObject(Array ('skip_autoload' => true));

			$object->SetDBField('Amount', $affiliate->GetDBField('AmountToPay'));
			$object->SetDBField('AffiliateId', $affiliate->GetID());
		}

		/**
		 * Updates Affiliate Record On Successfully payment creation
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 */
		protected function OnAfterItemCreate(kEvent $event)
		{
			parent::OnAfterItemCreate($event);

			/** @var kDBItem $object */
			$object = $event->getObject();

			$parent_info = $object->getLinkedInfo();

			$sql = 'SELECT MAX(PaymentDate)
					FROM ' . $object->TableName . '
					WHERE ' . $parent_info['ParentTableKey'] . ' = ' . $parent_info['ParentId'];
			$payment_date = $this->Conn->GetOne($sql);

			/** @var kDBItem $affiliate */
			$affiliate = $this->Application->recallObject('affil');

			$affiliate->SetDBField('AmountToPay', $affiliate->GetDBField('AmountToPay') - $object->GetDBField('Amount'));
			$affiliate->SetDBField('LastPaymentDate_date', $payment_date);
			$affiliate->SetDBField('LastPaymentDate_time', $payment_date);
			$affiliate->Update();
		}

		/**
		 * Apply any custom changes to list's sql query
		 *
		 * @param kEvent $event
		 * @return void
		 * @access protected
		 * @see kDBEventHandler::OnListBuild()
		 */
		protected function SetCustomQuery(kEvent $event)
		{
			parent::SetCustomQuery($event);

			/** @var kDBList $object */
			$object = $event->getObject();

			if ( $event->Special == 'log' ) {
				$object->removeFilter('parent_filter');
			}

			$types = $event->getEventParam('types');
			if ( $types == 'my_payments' ) {
				$user_id = $this->Application->RecallVar('user_id');
				$object->removeFilter('parent_filter');
				$object->addFilter('my_payments', 'au.PortalUserId = ' . $user_id);
			}

			if ( $types == 'myvisitororders' ) {
				$user_id = $this->Application->RecallVar('user_id');
				$object->addFilter('myitems_orders', 'ord.OrderId IS NOT NULL');
				$object->addFilter('myitems_user1', 'au.PortalUserId = ' . $user_id);
				$object->addFilter('myitems_user2', 'au.PortalUserId > 0');
			}
		}

	}