<?php
/**
* @version	$Id: products_config.php 16580 2017-07-18 11:31:13Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'p',
	'ItemClass' => Array ('class' => 'ProductsItem', 'file' => 'products_item.php', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kCatDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'ProductsEventHandler', 'file' => 'products_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'ProductsTagProcessor', 'file' => 'products_tag_processor.php', 'build_event' => 'OnBuild'),

	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'CatalogItem' => true,
	'AdminTemplatePath' => 'products',
	'AdminTemplatePrefix' => 'products_',

	'SearchConfigPostfix' => 'products',

	'ConfigPriority' => 0,

	'RewritePriority' => 104,
	'RewriteListener' => 'CategoryItemRewrite:RewriteListener',

	'Hooks' => Array (
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'lst',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnBeforeCopyToLive' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnSaveVirtualProduct',
		),

		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'lst',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterItemDelete'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnDeleteListingType',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'lst',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnModifyPaidListingConfig',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'file',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnNew', 'OnEdit' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnPreSave',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => '',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => 'cdata',
			'DoSpecial' => '*',
			'DoEvent' => 'OnDefineCustomFields',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'rev',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnCloneSubItem',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'fav',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnCloneSubItem',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'ci',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnCloneSubItem',
		),
	),

	'IDField' => 'ProductId',
	'StatusField' => Array ('Status'),	// field, that is affected by Approve/Decline events

	'TitleField' => 'Name',		// field, used in bluebar when editing existing item
	'ItemType' => 11,	// this is used when relation to product is added from in-portal and via-versa

	'ViewMenuPhrase' => 'la_text_Products',
	'CatalogTabIcon' => 'in-commerce:icon16_products.png',

	'ItemPropertyMappings' => Array (
		'NewDays' => 'Product_NewDays',		// number of days item to be NEW
		'MinPopVotes' => 'Product_MinPopVotes',	// minimum number of votes for an item to be POP
		'MinPopRating' => 'Product_MinPopRating',	// minimum rating for an item to be POP
		'MaxHotNumber' => 'Product_MaxHotNumber',	// maximum number of HOT (top seller) items

		'HotLimit' => 'Product_HotLimit',		// variable name in inp_Cache table
		'ClickField' => 'Hits',					// item click count is stored here (in item table)
	),

	'TitlePhrase' => 'la_text_Product',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('p' => '!la_title_Adding_Product!'),
			'edit_status_labels' => Array ('p' => '!la_title_Editing_Product!'),
			'new_titlefield' => Array ('p' => '!la_title_NewProduct!'),
		),
		'product_list' =>Array (
			'prefixes' => Array ('c_List', 'p_List'),
			'tag_params' => Array ('c' => Array ('per_page' =>-1)),
			'format' => "!la_title_Categories! (#c_recordcount#) - !la_title_Products! (#p_recordcount#)",
		),
		'products_edit' =>Array (
			'prefixes' => Array ('p'),
			'new_titlefield' => Array ('p' => '!la_title_NewProduct!'),
			'format' => "#p_status# '#p_titlefield#' - !la_title_General!",
		),
		'inventory' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# - '#p_titlefield#' - !la_title_Product_Inventory!"),
		'pricing' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Product_Pricing!"),
		'access_pricing' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Product_AccessPricing!"),
		'access' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Product_Access!"),
		'files' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Product_Files!"),
		'options' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Product_Options!"),
		'categories' => Array ('prefixes' => Array ('p', 'p-ci_List'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Categories!"),
		'relations' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Relations!"),
		'content' => Array ('prefixes' => Array ('p', 'p.content_List'), 'tag_params' => Array ('p.content' => Array ('types' => 'content', 'live_table' =>true)), 'format' => "#p_status# '#p_titlefield#' - !la_title_Product_PackageContent!"),
		'images' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Images!"),
		'reviews' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Reviews!"),
		'products_custom' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_Custom!"),
		'images_edit' => Array (
			'prefixes' => Array ('p', 'img'),
			'new_status_labels' => Array ('img' => '!la_title_Adding_Image!'),
			'edit_status_labels' => Array ('img' => '!la_title_Editing_Image!'),
			'new_titlefield' => Array ('img' => '!la_title_New_Image!'),
			'format' => "#p_status# '#p_titlefield#' - #img_status# '#img_titlefield#'",
		),
		'pricing_edit' => Array (
			'prefixes' => Array ('p', 'pr'),
			'new_status_labels' => Array ('pr' =>"!la_title_Adding_PriceBracket! '!la_title_New_PriceBracket!'"),
			'edit_status_labels' => Array ('pr' => '!la_title_Editing_PriceBracket!'),
			'format' => "#p_status# '#p_titlefield#' - #pr_status#",
		),
		'options_edit' => Array (
			'prefixes' => Array ('p', 'po'),
			'new_status_labels' => Array ('po' =>"!la_title_Adding_Option!"),
			'edit_status_labels' => Array ('po' => '!la_title_Editing_Option!'),
			'new_titlefield' => Array ('po' => '!la_title_New_Option!'),
			'format' => "#p_status# '#p_titlefield#' - #po_status# '#po_titlefield#'",
		),

		'options_combinations' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_ManagingOptionCombinations!"),
		'shipping_options' => Array ('prefixes' => Array ('p'), 'format' => "#p_status# '#p_titlefield#' - !la_title_ManagingShippingOptions!"),

		'file_edit' => Array (
			'prefixes' => Array ('p', 'file'),
			'new_status_labels' => Array ('file' =>"!la_title_Adding_File!"),
			'edit_status_labels' => Array ('file' => '!la_title_Editing_File!'),
			'new_titlefield' => Array ('file' => '!la_title_New_File!'),
			'format' => "#p_status# '#p_titlefield#' - #file_status# '#file_titlefield#'",
		),
		'relations_edit' => Array (
			'prefixes' => Array ('p', 'rel'),
			'new_status_labels' => Array ('rel' =>"!la_title_Adding_Relationship! '!la_title_New_Relationship!'"),
			'edit_status_labels' => Array ('rel' => '!la_title_Editing_Relationship!'),
			'format' => "#p_status# '#p_titlefield#' - #rel_status#",
		),
		'reviews_edit' => Array (
			'prefixes' => Array ('p', 'rev'),
			'new_status_labels' => Array ('rev' =>"!la_title_Adding_Review! '!la_title_New_Review!'"),
			'edit_status_labels' => Array ('rev' => '!la_title_Editing_Review!'),
			'format' => "#p_status# '#p_titlefield#' - #rev_status#",
		),

		'products_export' => Array ('format' => '!la_title_ProductsExport!'),

		'products_import' => Array ('format' => '!la_title_ImportProducts!'),

		'tree_in-commerce' => Array ('format' => '!la_Text_Version! '.$this->Application->findModule('Name', 'In-Commerce', 'Version')),
	),

	'EditTabPresets' => Array (
		'Default' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/products/products_edit', 'priority' => 1),
			'inventory' => Array ('title' => 'la_tab_Inventory', 't' => 'in-commerce/products/products_inventory', 'priority' => 2),
			'access_and_pricing' => Array ('title' => 'la_tab_AccessAndPricing', 't' => 'in-commerce/products/products_access', 'priority' => 3),
			'pricing' => Array ('title' => 'la_tab_Pricing', 't' => 'in-commerce/products/products_pricing', 'priority' => 4),

//			'pricing2' => Array ('title' => 'la_tab_Pricing', 't' => 'in-commerce/products/products_access_pricing', 'priority' => 5),

			'files_and_pricing' => Array ('title' => 'la_tab_FilesAndPricing', 't' => 'in-commerce/products/products_files', 'priority' => 6),
			'options' => Array ('title' => 'la_tab_Options', 't' => 'in-commerce/products/products_options', 'priority' => 7),
			'categories' => Array ('title' => 'la_tab_Categories', 't' => 'in-commerce/products/products_categories', 'priority' => 8),
			'relations' => Array ('title' => 'la_tab_Relations', 't' => 'in-commerce/products/products_relations', 'priority' => 9),
			'package_content' => Array ('title' => 'la_tab_PackageContent', 't' => 'in-commerce/products/products_packagecontent', 'priority' => 10),
			'images' => Array ('title' => 'la_tab_Images', 't' => 'in-commerce/products/products_images', 'priority' => 11),
			'reviews' => Array ('title' => 'la_tab_Reviews', 't' => 'in-commerce/products/products_reviews', 'priority' => 12),
			'custom' => Array ('title' => 'la_tab_Custom', 't' => 'in-commerce/products/products_custom', 'priority' => 13),
		),
	),

	'PermItemPrefix' => 'PRODUCT',

	'PermTabText' => 'In-Commerce',
	'PermSection' => Array ('main' => 'CATEGORY:in-commerce:products_list', 'search' => 'in-commerce:search', 'custom' => 'in-commerce:configuration_custom'),

	'Sections' => Array (
		'in-commerce' => Array (
			'parent' => 'in-portal:root',
			'icon' => 'ecommerce',
			'label' => 'la_title_In-Commerce',
			'url' => Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view'),
			'priority' => 2.1,
			'container' => true,
			'type' => stTREE,
		),

		'in-commerce:products' => Array (
			'parent' => 'in-portal:site',
			'icon' => 'products',
			'label' => 'la_tab_Products',
			'url' => Array ('t' => 'catalog/advanced_view', 'anchor' => 'tab-p.showall', 'pass' => 'm'),
			'onclick' => 'setCatalogTab(\'p.showall\')',
			'permissions' => Array ('view'),
			'priority' => 3.2,
			'type' => stTREE,
		),

		// product settings
		'in-commerce:setting_folder' => Array (
			'parent' => 'in-portal:system',
			'icon' => 'conf_ecommerce',
			'label' => 'la_title_In-Commerce',
			'use_parent_header' => 1,
			'url' => Array ('t' => 'index', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view'),
			'priority' => 3.1,
			'container' => true,
			'type' => stTREE,
		),

		'in-commerce:general' => Array (
			'parent' => 'in-commerce:setting_folder',
			'icon' => 'conf_ecommerce_general',
			'label' => 'la_tab_GeneralSettings',
			'url' => Array ('t' => 'config/config_general', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit'),
			'priority' => 1,
			'type' => stTREE,
		),

		'in-commerce:output' => Array (
			'parent' => 'in-commerce:setting_folder',
			'icon' => 'core:conf_output',
			'label' => 'la_tab_ConfigOutput',
			'url' => Array ('t' => 'config/config_universal', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit'),
			'priority' => 2,
			'type' => stTREE,
		),

		'in-commerce:search' => Array (
			'parent' => 'in-commerce:setting_folder',
			'icon' => 'core:conf_search',
			'label' => 'la_tab_ConfigSearch',
			'url' => Array ('t' => 'config/config_search', 'module_key' => 'products', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view', 'edit'),
			'priority' => 7,
			'type' => stTREE,
		),

		'in-commerce:configuration_custom' => Array (
			'parent' => 'in-commerce:setting_folder',
			'icon' => 'core:conf_customfields',
			'label' => 'la_tab_ConfigCustom',
			'url' => Array ('t' => 'custom_fields/custom_fields_list', 'cf_type' => 11, 'pass_section' => true, 'pass' => 'm,cf'),
			'permissions' => Array ('view', 'add', 'edit', 'delete'),
			'priority' => 8,
			'type' => stTREE,
		),

		'in-commerce:contacts' => Array (
			'parent' => 'in-commerce:setting_folder',
			'icon' => 'conf_contact_info',
			'label' => 'la_tab_ConfigContacts',
			'url' => Array ('t' => 'config/config_universal', 'pass_section' => true, 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit'),
			'priority' => 10,
			'type' => stTREE,
		),
	),

	'FilterMenu' => Array (
		'Groups' => Array (
			Array ('mode' => 'AND', 'filters' => Array ('show_new'), 'type' => kDBList::HAVING_FILTER),
			Array ('mode' => 'AND', 'filters' => Array ('show_hot'), 'type' => kDBList::HAVING_FILTER),
			Array ('mode' => 'AND', 'filters' => Array ('show_pop'), 'type' => kDBList::HAVING_FILTER),
			Array ('mode' => 'AND', 'filters' => Array ('show_pick'), 'type' => kDBList::WHERE_FILTER),
		),
		'Filters' => Array (
			'show_new' => Array ('label' => 'la_Text_New', 'on_sql' => '', 'off_sql' => '`IsNew` != 1'  ),
			'show_hot' => Array ('label' => 'la_Text_TopSellers', 'on_sql' => '', 'off_sql' => '`IsHot` != 1'  ),
			'show_pop' => Array ('label' => 'la_Text_Pop', 'on_sql' => '', 'off_sql' => '`IsPop` != 1'  ),
			'show_pick' => Array ('label' => 'la_prompt_EditorsPick', 'on_sql' => '', 'off_sql' => '%1$s.`EditorsPick` != 1'  ),
		)
	),

	'TableName' => TABLE_PREFIX . 'Products',
	'CustomDataTableName' => TABLE_PREFIX . 'ProductsCustomData',

	'CalculatedFields' => Array (
		'' => Array (
			'AltName' => 'img.AltName',
			'SameImages' => 'img.SameImages',
			'LocalThumb' => 'img.LocalThumb',
			'ThumbPath' => 'img.ThumbPath',
			'ThumbUrl' => 'img.ThumbUrl',
			'LocalImage' => 'img.LocalImage',
			'LocalPath' => 'img.LocalPath',
			'FullUrl' => 'img.Url',

			'Price' => 'COALESCE(pricing.Price, 0)',
			'Cost' => 'COALESCE(pricing.Cost, 0)',
			'PrimaryCat' => TABLE_PREFIX.'%3$sCategoryItems.PrimaryCat',
			'CategoryId' => TABLE_PREFIX.'%3$sCategoryItems.CategoryId',
			'ParentPath' => TABLE_PREFIX.'Categories.ParentPath',
			'Manufacturer' => TABLE_PREFIX.'Manufacturers.Name',
			'Filename' => TABLE_PREFIX.'%3$sCategoryItems.Filename',
			'CategoryFilename' => TABLE_PREFIX.'Categories.NamedParentPath',
			'FileSize' => 'files.Size',
			'FilePath' => 'files.FilePath',
			'FileVersion' => 'files.Version',
		),

		'showall' => Array (
			'Price' => 'COALESCE(pricing.Price, 0)',
			'Manufacturer' => TABLE_PREFIX.'Manufacturers.Name',
			'PrimaryCat' => TABLE_PREFIX.'%3$sCategoryItems.PrimaryCat',
			'CategoryId' => TABLE_PREFIX.'%3$sCategoryItems.CategoryId',
			'FileSize' => 'files.Size',
			'FilePath' => 'files.FilePath',
			'FileVersion' => 'files.Version',
			'Filename' => TABLE_PREFIX.'%3$sCategoryItems.Filename',
			'CategoryFilename' => TABLE_PREFIX.'Categories.NamedParentPath',
		),
	),

	'CacheModRewrite' => true,

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
					FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'UserGroups ON '.TABLE_PREFIX.'UserGroups.GroupId = %1$s.AccessGroupId
					LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
					{PERM_JOIN}
					LEFT JOIN '.TABLE_PREFIX.'Categories ON '.TABLE_PREFIX.'Categories.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
					LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
					LEFT JOIN '.TABLE_PREFIX.'%3$sProductFiles files ON files.ProductId = %1$s.ProductId AND files.IsPrimary = 1
					LEFT JOIN '.TABLE_PREFIX.'%3$sProductsPricing pricing ON pricing.ProductId = %1$s.ProductId AND pricing.IsPrimary = 1
					LEFT JOIN '.TABLE_PREFIX.'Manufacturers ON '.TABLE_PREFIX.'Manufacturers.ManufacturerId = %1$s.ManufacturerId
					LEFT JOIN '.TABLE_PREFIX.'%3$sProductsCustomData cust ON %1$s.ResourceId = cust.ResourceId',

		'showall' => 'SELECT %1$s.* %2$s FROM %1$s
					LEFT JOIN '.TABLE_PREFIX.'%3$sProductsPricing pricing ON pricing.ProductId = %1$s.ProductId AND pricing.IsPrimary = 1
					LEFT JOIN '.TABLE_PREFIX.'%3$sProductFiles files ON files.ProductId = %1$s.ProductId AND files.IsPrimary = 1
					LEFT JOIN '.TABLE_PREFIX.'Manufacturers ON '.TABLE_PREFIX.'Manufacturers.ManufacturerId = %1$s.ManufacturerId
					LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
					{PERM_JOIN}
					LEFT JOIN '.TABLE_PREFIX.'Categories ON '.TABLE_PREFIX.'Categories.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
					LEFT JOIN '.TABLE_PREFIX.'%3$sProductsCustomData cust ON %1$s.ResourceId = cust.ResourceId',
	),

	'ListSortings' => Array (
		'' => Array (
			'ForcedSorting' => Array ('EditorsPick' => 'desc', 'Priority' => 'desc'),
			'Sorting' => Array ('Name' => 'asc'),
		)
	),

	'ItemSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s
				LEFT JOIN '.TABLE_PREFIX.'UserGroups pg ON pg.GroupId = %1$s.AccessGroupId
				LEFT JOIN '.TABLE_PREFIX.'%3$sCategoryItems ON '.TABLE_PREFIX.'%3$sCategoryItems.ItemResourceId = %1$s.ResourceId
				LEFT JOIN '.TABLE_PREFIX.'Categories ON '.TABLE_PREFIX.'Categories.CategoryId = '.TABLE_PREFIX.'%3$sCategoryItems.CategoryId
				LEFT JOIN '.TABLE_PREFIX.'%3$sCatalogImages img ON img.ResourceId = %1$s.ResourceId AND img.DefaultImg = 1
				LEFT JOIN '.TABLE_PREFIX.'%3$sProductFiles files ON files.ProductId = %1$s.ProductId AND files.IsPrimary = 1
				LEFT JOIN '.TABLE_PREFIX.'%3$sProductsPricing pricing ON pricing.ProductId = %1$s.ProductId AND pricing.IsPrimary = 1
				LEFT JOIN '.TABLE_PREFIX.'Manufacturers ON '.TABLE_PREFIX.'Manufacturers.ManufacturerId = %1$s.ManufacturerId
				LEFT JOIN '.TABLE_PREFIX.'%3$sProductsCustomData cust ON %1$s.ResourceId = cust.ResourceId',
	),

	'SubItems' => Array ('pr', 'rev', 'img', 'po', 'poc', 'p-ci', 'rel', 'file', 'p-cdata', 'p-fav'),

	'Fields' => Array (
		'ProductId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0,),
		'Name' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'required' => 1, 'max_len' =>255, 'default' => ''),
		'AutomaticFilename' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'not_null' => 1, 'default' => 1,
		),
		'SKU' => Array ('type' => 'string', 'required' => 1, 'max_len' =>255, 'error_msgs' => Array ('required' => 'Please fill in'), 'default' => NULL),
		'Description' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'using_fck' => 1, 'default' => NULL),
		'DescriptionExcerpt' => Array ('type' => 'string', 'formatter' => 'kMultiLanguage', 'default' => NULL),
		'Weight' => Array ('type' => 'float', 'min_value_exc' => 0, 'formatter' => 'kUnitFormatter', 'format' => '%0.2f', 'default' => NULL),
		'MSRP' => Array ('type' => 'float', 'min_value_inc' => 0, 'formatter' => 'kFormatter', 'format' => '%0.2f', 'default' => NULL),
		'ManufacturerId' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Manufacturers ORDER BY Name', 'option_key_field' => 'ManufacturerId', 'option_title_field' => 'Name', 'not_null' => 1, 'default' => 0),
		'Status' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (1 => 'la_Active', 2 => 'la_Pending', 0 => 'la_Disabled'), 'use_phrases' => 1,
			'default' => 2, 'not_null' => 1,
		),
		'BackOrder' => Array ('type' => 'int', 'not_null' => 1, 'options' => Array ( 2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never' ), 'use_phrases' => 1, 'default' => 2 ),
		'BackOrderDate' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'error_msgs' => Array ('bad_date_format' => 'Please use the following date format: %s'), 'default' => NULL),
		'NewItem' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never' ), 'use_phrases' => 1, 'not_null' => 1, 'default' => 2 ),
		'HotItem' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never' ), 'use_phrases' => 1, 'not_null' => 1, 'default' => 2 ),
		'PopItem' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array ( 2 => 'la_Auto', 1 => 'la_Always', 0 => 'la_Never' ), 'use_phrases' => 1, 'not_null' => 1, 'default' => 2 ),
		'EditorsPick' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'Featured' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'OnSale' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'Priority' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'CachedRating' => Array ('type' => 'string', 'not_null' => 1, 'formatter' => 'kFormatter', 'default' => 0),
		'CachedVotesQty' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'Hits' => Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%d', 'not_null' => 1, 'default' => 0),
		'CreatedOn' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		'Expire' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' =>null),
		'Type' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
			'options' => Array (
				PRODUCT_TYPE_TANGIBLE => 'la_product_tangible',
				PRODUCT_TYPE_SUBSCRIPTION => 'la_product_subscription',
				PRODUCT_TYPE_SERVICE => 'la_product_service',
				PRODUCT_TYPE_DOWNLOADABLE => 'la_product_downloadable',
				/* PRODUCT_TYPE_PACKAGE => 'la_product_package', */
			),
			'not_null' => 1, 'default' => 1,
		),
		'Modified' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		'ModifiedById' => Array ('type' => 'int', 'default' => NULL),
		'CreatedById' => Array (
			'type' => 'int',
			'formatter' => 'kLEFTFormatter',
			'options' => Array (USER_ROOT => 'root', USER_GUEST => 'Guest'),
			'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'Users WHERE %s',
			'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD,
			'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),
			'sample_value' => 'Guest', 'required' => 1, 'default' => NULL,
		),
		'ResourceId' => Array ('type' => 'int', 'default' => null),
		'CachedReviewsQty' => Array ('type' => 'int', 'formatter' => 'kFormatter', 'format' => '%d', 'not_null' => 1, 'default' => 0),
		'InventoryStatus' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_Disabled', 1 => 'la_by_product', 2 => 'la_by_options'), 'use_phrases' => 1, 'not_null' => 1, 'default' => 0),
		'QtyInStock' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'QtyInStockMin' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'QtyReserved' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'QtyBackOrdered' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'QtyOnOrder' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'InventoryComment' => Array ('type' => 'string', 'default' => null),
		'Qty' => Array ('type' => 'int', 'formatter' => 'kFormatter', 'regexp' => '/^[\d]+$/', 'error_msgs' => Array ('invalid_format' => '!la_invalid_integer!')),
		'AccessGroupId' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'UserGroups WHERE System!=1 AND Personal !=1 ORDER BY Name', 'option_key_field' => 'GroupId', 'option_title_field' => 'Name', 'default' => NULL),
		'AccessDuration' => Array ('type' => 'int', 'default' => NULL),
		'AccessDurationType' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' =>Array (1 => 'la_opt_sec', 2 => 'la_opt_min', 3 => 'la_opt_hour', 4 => 'la_opt_day', 5 => 'la_opt_week', 6 => 'la_opt_month', 7 => 'la_opt_year' ), 'default' => NULL,),
		'AccessStart' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL),
		'AccessEnd' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => NULL,),
		'OptionsSelectionMode' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' =>Array (0 => 'la_opt_Selection', 1 => 'la_opt_List'), 'default' => 0),
		'HasRequiredOptions' => Array ('type' => 'int', 'default' => 0, 'not_null' => 1),
		'Virtual' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'ProcessingData' => Array ('type' => 'string', 'default' => ''),
		'PackageContent' => Array ('type' => 'string', 'default' => NULL),
		'IsRecurringBilling' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'not_null' => 1, 'default' => 0,
		),
		//'PayPalRecurring' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'not_null' => '1', 'default' => '0'),
		'ShippingMode' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'use_phrases' => 1, 'options' =>Array (0 => 'la_shipping_AnyAndSelected', 1 => 'la_shipping_Limited'), 'not_null' => 1, 'default' =>0),

		'ProcessingData' => Array ('type' => 'string', 'default' => null),

		'ShippingLimitation' => Array ('type' => 'string', 'default' => NULL),
		'AssignedCoupon' => Array (
			'type' => 'int',
			'formatter' => 'kLEFTFormatter', 'options' => Array (0 => 'None'),
			'left_sql' => 'SELECT %s FROM ' . TABLE_PREFIX . 'ProductsCoupons WHERE %s',
			'left_key_field' => 'CouponId', 'left_title_field' => 'Name',
			'not_null' => 1, 'default' => 0,
		),
		'MinQtyFreePromoShipping' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'MetaKeywords' => Array ('type' => 'string', 'default' => null),
		'MetaDescription' => Array ('type' => 'string', 'default' => null),
	),

	'VirtualFields' => Array (
		'Relevance' => Array ('type' => 'float', 'default' => 0),
		'Qty' => Array ('type' => 'int', 'formatter' => 'kFormatter', 'regexp' => '/^[\d]+$/', 'default' => 0),
		'Price' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%.2f', 'default' => NULL),
		'Cost' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%.2f', 'default' => NULL),
		'CategoryFilename' => Array ('type' => 'string', 'default' => ''),
		'PrimaryCat' => Array ('type' => 'int', 'default' => 0),
		'IsHot' => Array ('type' => 'int', 'default' => 0),
		'IsNew' => Array ('type' => 'int', 'default' => 0),
		'IsPop' => Array ('type' => 'int', 'default' => 0),
		'Manufacturer' => Array ('type' => 'string', 'default' => ''),

		// export related fields: begin
		'CategoryId' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => 0),
		'ExportFormat' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CSV', /*2 => 'XML'*/), 'default' => 1),
		'ExportFilename' => Array ('type' => 'string', 'default' => ''),
		'FieldsSeparatedBy' => Array ('type' => 'string', 'default' => ', '),
		'FieldsEnclosedBy' => Array ('type' => 'string', 'default' => '"'),
		'LineEndings' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'Windows', 2 => 'UNIX'), 'default' => 1),
		'LineEndingsInside' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CRLF', 2 => 'LF'), 'default' => 2),
		'IncludeFieldTitles' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'default' => 1,
		),
		'ExportColumns' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
		'AvailableColumns' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
		'CategoryFormat' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_MixedCategoryPath', 2 => 'la_SeparatedCategoryPath'), 'use_phrases' => 1, 'default' => 1),
		'CategorySeparator' => Array ('type' => 'string', 'default' => ':'),
		'IsBaseCategory' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'default' => 0,
		),
		// export related fields: end

		// import related fields: begin
		'FieldTitles' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Automatic', 2 => 'la_Manual'), 'use_phrases' => 1, 'default' => 1),
		'ImportSource' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Upload', 2 => 'la_Local'), 'use_phrases' => 1, 'default' => 2),
		'ImportFilename' => Array ('type' => 'string', 'formatter' => 'kUploadFormatter', 'max_size' => MAX_UPLOAD_SIZE, 'upload_dir' => EXPORT_BASE_PATH . '/', 'default' => ''),
		'ImportLocalFilename' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'default' => ''),
		'CheckDuplicatesMethod' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_IDField', 2 => 'la_OtherFields'), 'use_phrases' => 1, 'default' => 1),
		'ReplaceDuplicates' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1, 'default' => 0),
		'DuplicateCheckFields' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array ('Name' => 'NAME'), 'default' => '|Name|'),
		'SkipFirstRow' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'la_Yes', 0 => 'la_No'), 'use_phrases' => 1, 'default' => 1),
		// import related fields: end

		'ThumbnailImage' => Array ('type' => 'string', 'default' => ''),
		'FullImage' => Array ('type' => 'string', 'default' => ''),
		'ImageAlt' => Array ('type' => 'string', 'default' => ''),

		'Filename' => Array ('type' => 'string', 'default' => ''),
		'CachedNavbar' => Array ('type' => 'string', 'default' => ''),
		'ParentPath' => Array ('type' => 'string', 'default' => ''),

		'FileSize' => Array ('type' => 'int', 'formatter' => 'kFilesizeFormatter', 'default' => 0),
		'FilePath' => Array ('type' => 'string', 'default' => ''),
		'FileVersion' => Array ('type' => 'string', 'default' => ''),

		// for primary image
		'AltName' => Array ('type' => 'string', 'default' => ''),
		'SameImages' => Array ('type' => 'string', 'default' => ''),
		'LocalThumb' => Array ('type' => 'string', 'default' => ''),
		'ThumbPath' => Array ('type' => 'string', 'default' => ''),
		'ThumbUrl' => Array ('type' => 'string', 'default' => ''),
		'LocalImage' => Array ('type' => 'string', 'default' => ''),
		'LocalPath' => Array ('type' => 'string', 'default' => ''),
		'FullUrl' => Array ('type' => 'string', 'default' => ''),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_product.png',
				0 => 'icon16_product_disabled.png',
				1 => 'icon16_product.png',
				2 => 'icon16_product_pending.png',
				'NEW' => 'icon16_product_new.png',
			),
			'Fields' => Array (
				'ProductId' => Array ( 'title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
				'SKU' => Array ( 'title' => 'la_col_ProductSKU', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Name' => Array ( 'title' => 'la_col_ProductName', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
				'Priority' => Array ('filter_block' => 'grid_range_filter', 'width' => 65),
				'Type' => Array ('title' => 'column:la_fld_ProductType', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
				'Manufacturer' => Array ('filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Price' => Array ('filter_block' => 'grid_range_filter', 'width' => 70, ),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 70, ),
				'QtyInStock' => Array ('title' => 'column:la_fld_Qty', 'data_block' => 'qty_td', 'filter_block' => 'grid_range_filter', 'width' => 80, ),
				'QtyBackOrdered' => Array ('title' => 'column:la_fld_QtyBackOrdered', 'filter_block' => 'grid_range_filter', 'width' => 80, ),
				'OnSale' => Array ('title' => 'column:la_fld_OnSale', 'filter_block' => 'grid_options_filter', 'width' => 70, ),
				/*'Weight' => Array ( 'title' => 'la_col_ProductWeight', 'filter_block' => 'grid_range_filter', 'width' => 150, ),
				'CreatedOn' => Array ( 'title' => 'la_col_ProductCreatedOn', 'filter_block' => 'grid_date_range_filter', 'width' => 150, ),
				'BackOrderDate' => Array ( 'title' => 'la_col_ProductBackOrderDate', 'filter_block' => 'grid_date_range_filter', 'width' => 150, ),*/
			),
		),

		'Radio' => Array (
			'Icons' => Array (
				'default' => 'icon16_product.png',
				0 => 'icon16_product_disabled.png',
				1 => 'icon16_product.png',
				2 => 'icon16_product_pending.png',
				'NEW' => 'icon16_product_new.png',
			),
			'Selector' => 'radio',
			'Fields' => Array (
				'ProductId' => Array ( 'title' => 'column:la_fld_Id', 'data_block' => 'grid_radio_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
				'SKU' => Array ( 'title' => 'la_col_ProductSKU', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Name' => Array ( 'title' => 'la_col_ProductName', 'data_block' => 'grid_catitem_td', 'filter_block' => 'grid_like_filter', 'width' => 150, ),
				'Priority' => Array ('filter_block' => 'grid_range_filter', 'width' => 65),
				'Type' => Array ('title' => 'column:la_fld_ProductType', 'filter_block' => 'grid_options_filter', 'width' => 80, ),
				'Manufacturer' => Array ('filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Price' => Array ('filter_block' => 'grid_range_filter', 'width' => 70, ),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'width' => 70, ),
				'QtyInStock' => Array ('title' => 'column:la_fld_Qty', 'data_block' => 'qty_td', 'filter_block' => 'grid_range_filter', 'width' => 80, ),
				'QtyBackOrdered' => Array ('title' => 'column:la_fld_QtyBackOrdered', 'filter_block' => 'grid_range_filter', 'width' => 80, ),

			),
		),
	),

	'ConfigMapping' => Array (
		'PerPage' => 'Comm_Perpage_Products',
		'ShortListPerPage' => 'Comm_Perpage_Products_Short',
		'ForceEditorPick' => 'products_EditorPicksAboveRegular',
		'DefaultSorting1Field' => 'product_OrderProductsBy',
		'DefaultSorting2Field' => 'product_OrderProductsThenBy',
		'DefaultSorting1Dir' => 'product_OrderProductsByDir',
		'DefaultSorting2Dir' => 'product_OrderProductsThenByDir',

		'RatingDelayValue' => 'product_RatingDelay_Value',
		'RatingDelayInterval' => 'product_RatingDelay_Interval',
	),
);
