<?php
/**
* @version	$Id: brackets_event_handler.php 16516 2017-01-20 14:12:22Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

class BracketsEventHandler extends kDBEventHandler {

	/**
	 * Allows to override standard permission mapping
	 *
	 * @return void
	 * @access protected
	 * @see kEventHandler::$permMapping
	 */
	protected function mapPermissions()
	{
		parent::mapPermissions();

		$permissions = Array (
			'OnMoreBrackets' => Array ('subitem' => 'add|edit'),
			'OnInfinity' => Array ('subitem' => 'add|edit'),
			'OnArrange' => Array ('subitem' => 'add|edit'),
		);

		$this->permMapping = array_merge($this->permMapping, $permissions);
	}

	/**
	 * Apply some special processing to object being
	 * recalled before using it in other events that
	 * call prepareObject
	 *
	 * @param kDBItem|kDBList $object
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function prepareObject(&$object, kEvent $event)
	{
		if ( $this->Application->GetVar('s_id') === false ) {
			return;
		}

		/** @var kDBItem $shipping_object */
		$shipping_object = $this->Application->recallObject('s');

		/** @var LanguagesItem $lang_object */
		$lang_object = $this->Application->recallObject('lang.current');

		if ( $lang_object->GetDBField('UnitSystem') == 2 && $shipping_object->GetDBField('Type') == 1 ) {
			$fields = Array ('Start', 'End');

			/** @var kUnitFormatter $formatter */
			$formatter = $this->Application->recallObject('kUnitFormatter');

			foreach ($fields as $field) {
				$object->SetFieldOption($field, 'formatter', 'kUnitFormatter');
				$options = $object->GetFieldOptions($field);

				$formatter->prepareOptions($field, $options, $object);
			}
		}
	}

	function prepareBrackets($event)
	{
		/** @var LanguagesItem $lang_object */
		$lang_object = $this->Application->recallObject('lang.current');

		/** @var kDBItem $shipping_object */
		$shipping_object = $this->Application->recallObject('s');

		if ( $lang_object->GetDBField('UnitSystem') != 2 || $shipping_object->GetDBField('Type') != 1 ) {
			return;
		}

		$item_info = $this->Application->GetVar( $event->getPrefixSpecial() );

		foreach ($item_info as $id => $item_data) {
			if ( $item_info[$id]['Start_a'] === '' && $item_info[$id]['Start_b'] === '' ) {
				$item_info[$id]['Start'] = '';
			}
			else {
				$item_info[$id]['Start'] = kUtil::Pounds2Kg($item_info[$id]['Start_a'], $item_info[$id]['Start_b']);
			}

			if ( $item_info[$id]['End_a'] == '&#8734;' || $item_info[$id]['End_a'] == '&infin;' ) {
				$item_info[$id]['End'] = '&#8734;';
			}
			elseif ( $item_info[$id]['End_a'] === '' && $item_info[$id]['End_b'] === '' ) {
				$item_info[$id]['End'] = '';
			}
			else {
				$item_info[$id]['End'] = kUtil::Pounds2Kg($item_info[$id]['End_a'], $item_info[$id]['End_b']);
			}
		}

		$this->Application->SetVar($event->getPrefixSpecial(), $item_info);
	}

	/**
	 * Adds additional 5 empty brackets
	 *
	 * @param kEvent $event
	 */
	function OnMoreBrackets($event)
	{
		$brackets_helper =& $this->getHelper($event);

		$brackets_helper->OnMoreBrackets($event);
	}

	/**
	 * Arrange brackets
	 *
	 * @param kEvent $event
	 */
	function OnArrange($event)
	{
		$brackets_helper =& $this->getHelper($event);

		$brackets_helper->arrangeBrackets($event);
		$event->CallSubEvent('OnPreSaveBrackets');
	}

	/**
	 * Arrange infinity brackets
	 *
	 * @param kEvent $event
	 */
	function OnInfinity($event)
	{
		$brackets_helper =& $this->getHelper($event);

		$brackets_helper->arrangeBrackets($event);
		$event->CallSubEvent('OnPreSaveBrackets');

		$brackets_helper->OnInfinity($event);
		$event->CallSubEvent('OnPreSaveBrackets');
	}

	/**
	 * Initializes kBracketsHelper class based on event
	 *
	 * @param kEvent $event
	 * @param bool $event_readonly
	 * @return kBracketsHelper
	 */
	protected function &getHelper($event, $event_readonly = false)
	{
		/** @var kDBItem $shipping_object */
		$shipping_object = $this->Application->recallObject('s');

		$default_start = $shipping_object->GetDBField('Type') == 1 ? 0 : 1;

		if ( !$event_readonly ) {
			$this->prepareBrackets($event);
			$event->redirect = false;
		}

		/** @var kBracketsHelper $brackets_helper */
		$brackets_helper = $this->Application->recallObject('BracketsHelper');

		$brackets_helper->InitHelper('Start', 'End', Array (), $default_start);

		return $brackets_helper;
	}

	/**
	 * Occurs before updating item
	 *
	 * @param kEvent $event
	 * @return void
	 * @access protected
	 */
	protected function OnBeforeItemUpdate(kEvent $event)
	{
		parent::OnBeforeItemUpdate($event);

		/** @var kDBItem $object */
		$object = $event->getObject();

		$linked_info = $object->getLinkedInfo();
		$object->SetDBField($linked_info['ParentTableKey'], $linked_info['ParentId']);

		$brackets_helper =& $this->getHelper($event, true);
		$brackets_helper->replaceInfinity($event);
	}

	/**
	 * Enter description here...
	 *
	 * @param kEvent $event
	 */
	function OnPreSaveBrackets($event)
	{
		/** @var LanguagesItem $lang_object */
		$lang_object = $this->Application->recallObject('lang.current');

		/** @var kDBItem $shipping_object */
		$shipping_object = $this->Application->recallObject('s');

		if ( $lang_object->GetDBField('UnitSystem') == 2 && $shipping_object->GetDBField('Type') == 1 ) {
			$item_info = $this->Application->GetVar($event->getPrefixSpecial());

			if ( is_array($item_info) ) {
				foreach ($item_info as $id => $values) {
					if ( $values['End'] == -1 ) {
						$item_info[$id]['End_a'] = -1 / kUtil::POUND_TO_KG;
						$item_info[$id]['End_b'] = 0;
					}
				}
				$this->Application->SetVar($event->getPrefixSpecial(), $item_info);
			}
		}

		$brackets_helper =& $this->getHelper($event, true);
		$brackets_helper->OnPreSaveBrackets($event);
	}

}