<?php
/**
* @version	$Id: affiliate_payments_config.php 16580 2017-07-18 11:31:13Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'apayments',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'AffiliatePaymentsEventHandler', 'file' => 'affiliate_payments_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'AffiliatePaymentsTagProcessor', 'file' => 'affiliate_payments_tag_processor.php', 'build_event' => 'OnBuild'),
	'AutoLoad' => true,

	'AggregateTags' => Array (
		Array (
			'AggregateTo' => 'ord',
			'AggregatedTagName' => 'InitPaymentsList',
			'LocalTagName' => 'InitList',
		),
		Array (
			'AggregateTo' => 'ord',
			'AggregatedTagName' => 'ListPayments',
			'LocalTagName' => 'ListPayments',
		),
		Array (
			'AggregateTo' => 'ord',
			'AggregatedTagName' => 'PaymentsPaginationBar',
			'LocalTagName' => 'PaginationBar',
		),
		Array (
			'AggregateTo' => 'ord',
			'AggregatedTagName' => 'PaymentsCount',
			'LocalTagName' => 'TotalRecords',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
	),

	'IDField' => 'AffiliatePaymentId',

	'TitlePresets' => Array (
		'payments_log' => Array (
			'prefixes' => Array ('apayments.log_List'), 'format' => "!la_title_AffiliatePayments!",
		),
	),

	'Sections' => Array (
		'in-commerce:paymentlog' => Array (
			'parent' => 'in-commerce',
			'icon' => 'transactions',
			'label' => 'la_tab_PaymentLog',
			'url' => Array ('t' => 'in-commerce/payments/payments_list', 'pass' => 'm'),
			'permissions' => Array ('view'),
			'priority' => 6,
			'type' => stTREE,
		),
	),

	'TableName' => TABLE_PREFIX.'AffiliatePayments',

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s
				LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
				LEFT JOIN '.TABLE_PREFIX.'Users au ON af.PortalUserId = au.PortalUserId'
	),

	'CalculatedFields' => Array (
		'' => Array (
			'PortalUserId' => 'af.PortalUserId',
		),
		'log' => Array (
			'Username' => 'IF(au.Username = "", au.Email, au.Username)',
			'PortalUserId' => 'af.PortalUserId',
		),
	),

	'ForeignKey' => 'AffiliateId',
	'ParentTableKey' => 'AffiliateId',
	'ParentPrefix' => 'affil',
	'AutoDelete' => true,
	'AutoClone' => true,

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('PaymentDate' => 'desc'),
		)
	),

	'Fields' => Array (
		'AffiliatePaymentId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'AffiliateId' => Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' => Array (0 => 'lu_None'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Affiliates af LEFT JOIN '.TABLE_PREFIX.'Users u ON u.PortalUserId = af.PortalUserId WHERE %s', 'left_key_field' => 'af.AffiliateId', 'left_title_field' => 'IF(u.Email = "", u.Username, u.Email)', 'not_null'=>1,'default'=>0),
		'PaymentDate' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		'Amount' => Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%.02f', 'not_null' => '1', 'required'=>1, 'default' => '0.00'),
		'Comment' => Array ('type' => 'string', 'default' => NULL),
		'PaymentReference' => Array ('type' => 'string', 'not_null' => '1', 'default' => ''),
		'PaymentTypeId' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options_sql' => 'SELECT Name, PaymentTypeId FROM '.TABLE_PREFIX.'AffiliatePaymentTypes WHERE Status = 1 ORDER BY IsPrimary DESC, Priority DESC, Name ASC', 'option_key_field' => 'PaymentTypeId', 'option_title_field' => 'Name', 'not_null' => 1, 'default' => 0),
	),

	'VirtualFields' => Array (
		'Username' => Array ('type' => 'string', 'default' => ''),
		'PortalUserId' => Array ('type' => 'int', 'default' => 0),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				'module' => 'core',
			),
			'Fields' => Array (
				'AffiliatePaymentId'=> Array ( 'title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
				'PaymentDate' => Array ( 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
				'Amount' => Array ( 'filter_block' => 'grid_range_filter'),
				'Comment' => Array ( 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
				'PaymentTypeId' => Array ( 'title' => 'column:la_fld_PaymentType', 'filter_block' => 'grid_options_filter'),
				'PaymentReference' => Array ( 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
			),
		),
		'Log' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				'module' => 'core',
			),
			'Fields' => Array (
				'AffiliatePaymentId'=> Array ( 'title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 60, ),
				'Username' => Array ( 'data_block' => 'grid_userlink_td', 'filter_block' => 'grid_like_filter'),
				'PaymentDate' => Array ( 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
				'Amount' => Array ( 'data_block' => 'grid_currency_td', 'filter_block' => 'grid_range_filter'),
				'Comment' => Array ( 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
				'PaymentTypeId' => Array ( 'title' => 'column:la_fld_PaymentType', 'filter_block' => 'grid_options_filter'),
				'PaymentReference' => Array ( 'filter_block' => 'grid_like_filter', 'first_chars' => 50),
			),
		),
	),
);
