<?php
/**
* @version	$Id: orders_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'ord',
	'ItemClass' => Array ('class' => 'OrdersItem', 'file' => 'orders_item.php', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'OrdersEventHandler', 'file' => 'orders_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'OrdersTagProcessor', 'file' => 'orders_tag_processor.php', 'build_event' => 'OnBuild'),
	'ValidatorClass' => 'OrderValidator',

	'AutoLoad' => true,

	'RegisterClasses' => Array (
		Array ('pseudo' => 'OrderCalculator', 'class' => 'OrderCalculator', 'file' => 'order_calculator.php', 'build_event' => ''),
		Array ('pseudo' => 'OrderManager', 'class' => 'OrderManager', 'file' => 'order_manager.php', 'build_event' => ''),
		Array ('pseudo' => 'OrderValidator', 'class' => 'OrderValidator', 'file' => 'order_validator.php', 'build_event' => ''),
	),

	'Hooks' => Array (
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'ord',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnPreSave' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnRecalculateItems',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => '',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnUpdateCart', 'OnUpdateCartJSON', 'OnCheckout' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnApplyCoupon',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => '',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnUpdateCart', 'OnUpdateCartJSON', 'OnCheckout' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnApplyGiftCertificate',
		),

		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'u',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ( 'OnCreate' ),
			'DoPrefix' => '',
			'DoSpecial' => '*',
			'DoEvent' => 'OnUserCreate',
		),

		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'u',
			'HookToSpecial' => '',
			'HookToEvent' => Array ('OnCheckExpiredMembership'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnCheckRecurringOrders',
		),

		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'u',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnAfterLogin' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnUserLogin',
		),

		Array (
			'Mode' => hBEFORE, // before because OnInpLogin is called after real in-portal login and uses data from hooks
			'Conditional' => false,
			'HookToPrefix' => 'u',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnInpLogin' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnUserLogin',
		),
		Array (
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'adm',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnStartup'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnRestoreOrder',
		),
		array(
			'Mode' => hAFTER,
			'Conditional' => false,
			'HookToPrefix' => 'conf',
			'HookToSpecial' => '',
			'HookToEvent' => array('OnBeforeItemValidate'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnBeforeNextOrderNumberChange',
		),
	),

	'AggregateTags' => Array (
		Array (
			'AggregateTo' => 'orditems',
			'AggregatedTagName' => 'LinkRemoveFromCart',
			'LocalTagName' => 'Orditems_LinkRemoveFromCart',
		),
		Array (
			'AggregateTo' => 'orditems',
			'AggregatedTagName' => 'ProductLink',
			'LocalTagName' => 'Orderitems_ProductLink',
		),
		Array (
			'AggregateTo' => 'orditems',
			'AggregatedTagName' => 'ProductExists',
			'LocalTagName' => 'Orderitems_ProductExists',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'IDField' => 'OrderId',
	'StatusField' => Array ('Status'),	// field, that is affected by Approve/Decline events

	'ViewMenuPhrase' => 'la_title_Orders',
	'CatalogTabIcon' => 'icon16_item.png',

	'TitleField' => 'OrderNumber',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('ord' => '!la_title_Adding_Order!'),
			'edit_status_labels' => Array ('ord' => '!la_title_Editing_Order!'),
			'new_titlefield' => Array ('ord' => '!la_title_New_Order!'),
		),

		'orders_incomplete' => Array (
			'prefixes' => Array ('ord.incomplete_List'), 'format' => "!la_title_IncompleteOrders!",
		),

		'orders_pending' => Array (
			'prefixes' => Array ('ord.pending_List'), 'format' => "!la_title_PendingOrders!",
		),

		'orders_backorders' => Array (
			'prefixes' => Array ('ord.backorders_List'), 'format' => "!la_title_BackOrders!",
		),

		'orders_toship' => Array (
			'prefixes' => Array ('ord.toship_List'), 'format' => "!la_title_OrdersToShip!",
		),

		'orders_processed' => Array (
			'prefixes' => Array ('ord.processed_List'), 'format' => "!la_title_OrdersProcessed!",
		),

		'orders_returns' => Array (
			'prefixes' => Array ('ord.returns_List'), 'format' => "!la_title_OrdersReturns!",
		),

		'orders_denied' => Array (
			'prefixes' => Array ('ord.denied_List'), 'format' => "!la_title_OrdersDenied!",
		),

		'orders_archived' => Array (
			'prefixes' => Array ('ord.archived_List'), 'format' => "!la_title_OrdersArchived!",
		),

		'orders_search' => Array (
			'prefixes' => Array ('ord.search_List'), 'format' => "!la_title_OrdersSearch!",
		),

		'orders_edit_general' => Array ('prefixes' => Array ('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_General!"),
		'orders_edit_billing' => Array ('prefixes' => Array ('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderBilling!"),
		'orders_edit_shipping' => Array ('prefixes' => Array ('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderShipping!"),
		'orders_edit_items' => Array ('prefixes' => Array ('ord', 'orditems_List'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderItems!"),
		'orders_edit_preview' => Array ('prefixes' => Array ('ord'), 'format' => "#ord_status# '#ord_titlefield#' - !la_title_OrderPreview!"),

		'orders_gw_result' => Array ('prefixes' => Array ('ord'), 'format' => "!la_title_OrderGWResult!"),

		'orders_export' => Array ('format' => '!la_title_OrdersExport!'),

		'orders_product_edit' => Array ('format' => '!la_title_Editing_Order_Item!'),
	),

	'EditTabPresets' => Array (
		'Default' => Array (
			'general' => Array ('title' => 'la_tab_General', 't' => 'in-commerce/orders/orders_edit', 'priority' => 1),
			'items' => Array ('title' => 'la_tab_Items', 't' => 'in-commerce/orders/orders_edit_items', 'priority' => 2),
			'shipping' => Array ('title' => 'la_tab_Shipping', 't' => 'in-commerce/orders/orders_edit_shipping', 'priority' => 3),
			'billing' => Array ('title' => 'la_tab_Billing', 't' => 'in-commerce/orders/orders_edit_billing', 'priority' => 4),
			'preview' => Array ('title' => 'la_tab_Preview', 't' => 'in-commerce/orders/orders_edit_preview', 'priority' => 5),
		),
	),

	'PermSection' => Array ('main' => 'in-commerce:orders'),

	'Sections' => Array (
		'in-commerce:orders' => Array (
			'parent' => 'in-commerce',
			'icon' => 'in-commerce:orders',
			'label' => 'la_tab_Orders',
			'url' => Array ('t' => 'in-commerce/orders/orders_pending_list', 'pass' => 'm'),
			'permissions' => Array ('view', 'add', 'edit', 'delete', 'advanced:approve', 'advanced:deny', 'advanced:archive', 'advanced:place', 'advanced:process', 'advanced:ship', 'advanced:reset_to_pending'),
			'priority' => 1,
			'type' => stTREE,
		),
	),

	'SectionAdjustments' => Array (
		'in-portal:visits' => Array (
			'url' => Array ('t' => 'in-commerce/visits/visits_list_incommerce', 'pass' => 'm'),
		),
	),

	'StatisticsInfo' => Array (
		'pending' => Array (
			'icon' => 'core:icon16_item.png',
			'label' => 'la_title_Orders',
			'js_url' => "#url#",
			'url' => Array ('t' => 'in-commerce/orders/orders_pending_list', 'pass' => 'm'),
			'status' => ORDER_STATUS_PENDING,
		),
	),

	'TableName' => TABLE_PREFIX . 'Orders',

	'CalculatedFields' => Array (
		'' => Array (
			'CustomerName' => 'IF( ISNULL(u.Username), IF (%1$s.PortalUserId = ' . USER_ROOT . ', "root", IF (%1$s.PortalUserId = ' . USER_GUEST . ', "Guest", "n/a")), CONCAT(u.FirstName," ",u.LastName) )',
			'Username' => 'IF( ISNULL(u.Username),"root",IF(u.Username = "", u.Email, u.Username))',
			'OrderNumber' => 'CONCAT(LPAD(%1$s.Number,6,"0"),\'-\',LPAD(%1$s.SubNumber,3,"0") )',
			'SubtotalWithoutDiscount' => '(%1$s.SubTotal + %1$s.DiscountTotal)',
			'SubtotalWithDiscount' => '(%1$s.SubTotal)',
			'AmountWithoutVAT' => '(%1$s.SubTotal+IF(%1$s.ShippingTaxable=1, %1$s.ShippingCost, 0)+IF(%1$s.ProcessingTaxable=1, %1$s.ProcessingFee, 0)-IF(%1$s.VATIncluded=1,%1$s.VAT,0))',
			'TotalAmount' => '%1$s.SubTotal+%1$s.ShippingCost+IF(%1$s.VATIncluded=1,0,%1$s.VAT)+%1$s.ProcessingFee+%1$s.InsuranceFee-%1$s.GiftCertificateDiscount',
			'CouponCode' => 'pc.Code',
			'CouponName' => 'pc.Name',
			'AffiliateUser' => 'IF(au.PortalUserId IS NULL, "!la_None!", IF(au.Username = "", au.Email, au.Username))',
			'AffiliatePortalUserId' => 'af.PortalUserId',
			'GiftCertificateCode' => 'gc.Code',
			'GiftCertificateRecipient' => 'gc.Recipient',
			'ShippingSubTotal' => '%1$s.ShippingCost + %1$s.InsuranceFee',
		),

		'myorders' => Array (
			'OrderNumber' => 'CONCAT(LPAD(%1$s.Number,6,"0"),\'-\',LPAD(%1$s.SubNumber,3,"0") )',
			'SubtotalWithoutDiscount' => '(%1$s.SubTotal + %1$s.DiscountTotal)',
			'SubtotalWithDiscount' => '(%1$s.SubTotal)',
			'AmountWithoutVAT' => '(%1$s.SubTotal+IF(%1$s.ShippingTaxable=1, %1$s.ShippingCost, 0)+IF(%1$s.ProcessingTaxable=1, %1$s.ProcessingFee, 0)-IF(%1$s.VATIncluded=1,%1$s.VAT,0))',
			'TotalAmount' => '%1$s.SubTotal+%1$s.ShippingCost+IF(%1$s.VATIncluded=1,0,%1$s.VAT)+%1$s.ProcessingFee+%1$s.InsuranceFee-%1$s.GiftCertificateDiscount',
			/*'ItemsCount' => 'COUNT(%1$s.OrderId)',*/
			'ShippingSubTotal' => '%1$s.ShippingCost + %1$s.InsuranceFee',
		),
	),
	// %1$s - table name of object
	// %2$s - calculated fields
	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s
				LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.PortalUserId = u.PortalUserId
				LEFT JOIN '.TABLE_PREFIX.'ProductsCoupons pc ON %1$s.CouponId = pc.CouponId
				LEFT JOIN '.TABLE_PREFIX.'GiftCertificates gc ON %1$s.GiftCertificateId = gc.GiftCertificateId
				LEFT JOIN '.TABLE_PREFIX.'Affiliates af ON %1$s.AffiliateId = af.AffiliateId
				LEFT JOIN '.TABLE_PREFIX.'Users au ON af.PortalUserId = au.PortalUserId',

		'myorders' => '	SELECT %1$s.* %2$s
						FROM %1$s
						LEFT JOIN '.TABLE_PREFIX.'Users u ON %1$s.PortalUserId = u.PortalUserId',
//						LEFT JOIN '.TABLE_PREFIX.'OrderItems ON %1$s.OrderId = '.TABLE_PREFIX.'OrderItems.OrderId',
	),

	'SubItems' => Array ('orditems'),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('OrderDate' => 'desc'),
		)
	),

	'Fields' => Array (
		'OrderId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, 'filter_type' => 'equals'),
		'Number' => Array ('type' => 'int', 'required' =>1, 'formatter' => 'kFormatter', 'unique' =>Array ('SubNumber'), 'format' => '%06d', 'max_value_inc'>999999, 'not_null' => 1, 'default' => 0),
		'SubNumber' => Array ('type' => 'int', 'required' =>1, 'formatter' => 'kFormatter', 'unique' =>Array ('Number'), 'format' => '%03d', 'max_value_inc'>999, 'not_null' => 1, 'default' => 0),
		'Status' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' =>Array (0=> 'la_Incomplete',1=> 'la_Pending',2=> 'la_BackOrders',3=> 'la_ToShip',4=> 'la_Processed',5=> 'la_Denied',6=> 'la_Archived'), 'use_phrases' =>1, 'not_null' => 1, 'default' => 0, 'filter_type' => 'equals'),
		'OnHold' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'OrderDate' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'required' => 1, 'default' => '#NOW#'),
		'PortalUserId' =>Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'), 'options' =>Array (USER_ROOT => 'root', USER_GUEST => 'Guest'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Users WHERE %s', 'left_key_field' => 'PortalUserId', 'left_title_field' => USER_TITLE_FIELD, 'required' =>1, 'not_null' =>1, 'default' =>-1),
		'OrderIP' => Array ('type' => 'string', 'not_null' => 1, 'default' => '', 'filter_type' => 'like'),
		'UserComment' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),
		'AdminComment' => Array ('type' => 'string', 'formatter' => 'kFormatter', 'using_fck' => 1, 'default' => NULL),
		'BillingTo' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingCompany' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingPhone' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingFax' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingEmail' => Array (
			'type' => 'string',
			'formatter' => 'kFormatter',
			'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i',
			'error_msgs' => Array ('invalid_format' => '!la_invalid_email!', 'unique' => '!lu_email_already_exist!'),
			'not_null' => 1, 'default' => '',
		),
		'BillingAddress1' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingAddress2' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingCity' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingState' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (),
			'option_key_field' => 'DestAbbr',
			'option_title_field' => 'Translation',
			'not_null' => 1, 'default' => '',
		),
		'BillingZip' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'BillingCountry' => Array (
			'type' => 'string',
			'formatter' => 'kOptionsFormatter',
			'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
								FROM '.TABLE_PREFIX.'CountryStates
								WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
								ORDER BY Name',
			'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
			'not_null' => 1, 'default' => 'USA'
		),
		'VAT' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'not_null' =>1, 'default' => '0', 'format' => '%01.2f'),
		'VATPercent' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'not_null' =>1, 'default' => '0', 'format' => '%01.3f'),
		'VATIncluded' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'), 'use_phrases' => 1,
			'not_null' => 1, 'default' => 0,
		),
		'PaymentType' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options_sql' => 'SELECT IF(l%2$s_Description <> "", l%2$s_Description, l%3$s_Description) AS Description, PaymentTypeId
								FROM ' . TABLE_PREFIX . 'PaymentTypes
								WHERE Status = 1
								ORDER BY Priority DESC, Name ASC',
			'option_key_field' => 'PaymentTypeId', 'option_title_field' => 'Description',
			'not_null' => 1, 'default' => 0
		),

		'PaymentAccount' => Array ('type' => 'string', 'not_null' => 1, 'cardtype_field' => 'PaymentCardType', 'default' => '', 'filter_type' => 'like'),
		'PaymentNameOnCard' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'PaymentCCExpDate' => Array ('type' => 'string', 'formatter' => 'kCCDateFormatter', 'month_field' => 'PaymentCCExpMonth', 'year_field' => 'PaymentCCExpYear', 'not_null' => 1, 'default' => ''),
		'PaymentCardType' => Array ('type' => 'string', 'not_null' => 1, 'formatter' => 'kOptionsFormatter', 'options' => Array ('' => '', '1' => 'Visa', '2' => 'Mastercard', '3' => 'Amex', '4' => 'Discover', '5' => 'Diners Club', '6' => 'JBC'), 'default' => ''),
		'PaymentExpires' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => '#NOW#'),
		'ShippingTo' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingCompany' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingPhone' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingFax' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingEmail' => Array (
			'type' => 'string',
			'formatter' => 'kFormatter',
			'regexp' => '/^(' . REGEX_EMAIL_USER . '@' . REGEX_EMAIL_DOMAIN . ')$/i',
			'error_msgs' => Array ('invalid_format' => '!la_invalid_email!'),
			'not_null' => 1, 'default' => '',
		),
		'ShippingAddress1' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingAddress2' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingCity' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingState' => Array (
			'type' => 'string', 'formatter' => 'kOptionsFormatter',
									'options' => Array (),
									'option_key_field' => 'DestAbbr', 'option_title_field' => 'Translation',
									'not_null' => 1, 'default' => ''),
		'ShippingZip' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingCountry' => Array (
			'type' => 'string', 'formatter' => 'kOptionsFormatter',
			'options_sql' => '	SELECT IF(l%2$s_Name = "", l%3$s_Name, l%2$s_Name) AS Name, IsoCode
								FROM '.TABLE_PREFIX.'CountryStates
								WHERE Type = ' . DESTINATION_TYPE_COUNTRY . '
								ORDER BY Name',
			'option_key_field' => 'IsoCode', 'option_title_field' => 'Name',
			'not_null' => 1, 'default' => 'USA'
		),
		'ShippingType' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options_sql' => 'SELECT %s
									FROM ' . TABLE_PREFIX . 'ShippingType
								WHERE Status = 1',
			'option_key_field' => 'ShippingID',
			'option_title_field' => 'Name',
			'not_null' => 1, 'default' => 0,
		),
		'ShippingCost' => Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00'),
		'ShippingCustomerAccount' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingTracking' => Array ('type' => 'string', 'not_null' => 1, 'default' => ''),
		'ShippingDate' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
		'SubTotal' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00'),
		'ReturnTotal' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00'),
		'CostTotal' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00'),
		'OriginalAmount' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00'),
		'ShippingOption' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (
				0 => 'la_ship_all_together', 1 => 'la_ship_backorder_separately', 2 => 'la_ship_backorders_upon_avail',
			),
			'use_phrases' => 1, 'not_null' => 1, 'default' => 0,
		),
		'ShippingGroupOption' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter', 'use_phrases' => 1,
			'options' => Array (0 => 'la_opt_AutoGroupShipments', 1 => 'la_opt_ManualGroupShipments'),
			'not_null' => 1, 'default' => 0,
		),
		'GiftCertificateId' => Array ('type' => 'int', 'default' => null),
		'GiftCertificateDiscount' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00',),
		'ShippingInfo' => Array ('type' => 'string', 'default' => NULL),
		'CouponId' => Array ('type' => 'int', 'default' => null),
		'CouponDiscount' => Array ('type' => 'float', 'not_null' => 1, 'default' => '0.00', 'formatter' => 'kFormatter', 'format' => '%01.2f'),
		'DiscountTotal' => Array ('type' => 'float', 'not_null' => 1, 'default' => '0.00', 'formatter' => 'kFormatter', 'format' => '%01.2f'),
		'TransactionStatus' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_opt_Invalid', 1 => 'la_opt_Verified', 2 => 'la_opt_Pending'),
			'use_phrases' =>1, 'not_null' => 1, 'default' => 2,
		),
		'GWResult1' => Array ('type' => 'string', 'formatter' => 'kSerializedFormatter', 'default' => NULL),
		'GWResult2' => Array ('type' => 'string', 'formatter' => 'kSerializedFormatter', 'default' => NULL),
		'AffiliateId' => Array ('type' => 'int', 'formatter' => 'kLEFTFormatter', 'error_msgs' => Array ('invalid_option' => '!la_error_UserNotFound!'),  'options' => Array (0 => 'lu_None'), 'left_sql' => 'SELECT %s FROM '.TABLE_PREFIX.'Affiliates af LEFT JOIN '.TABLE_PREFIX.'Users u ON u.PortalUserId = af.PortalUserId WHERE %s', 'left_key_field' => 'AffiliateId', 'left_title_field' => 'IF(u.Email = "", u.Username, u.Email)', 'not_null' =>1, 'default' =>0),
		'VisitId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'AffiliateCommission' => Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%.02f', 'not_null' => 1, 'default' => '0.0000'),
		'ProcessingFee' => Array ('type' => 'double', 'formatter' => 'kFormatter', 'format' => '%.02f', 'not_null' => '0', 'default' => '0.0000'),
		'InsuranceFee' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'not_null' => 1, 'default' => '0.00'),
		'ShippingTaxable' => Array ('type' => 'int', 'not_null' => 0, 'default' => 0),
		'ProcessingTaxable' => Array ('type' => 'int', 'not_null' => 0, 'default' => 0),
		'IsRecurringBilling' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
			'default' => 0, 'not_null' => 1,
		),
		'ChargeOnNextApprove' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes',), 'use_phrases' => 1,
			'default' => 0, 'not_null' => 1,
		),
		'NextCharge' => Array ('type' => 'int', 'formatter' => 'kDateFormatter', 'default' => null),
		'GroupId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0),
		'GoogleOrderNumber' => Array ('type' => 'string', 'default' => NULL), // MySQL BIGINT UNSIGNED = 8 Bytes, PHP int = 4 Bytes -> threat as string
	),

	'VirtualFields' => Array (
		'CustomerName' => Array ('type' => 'string', 'default' => '', 'filter_type' => 'like'),
		'TotalAmount' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'default' => '0.00'),
		'AmountWithoutVAT' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'default' => '0.00'),
		'SubtotalWithDiscount' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'default' => '0.00'),
		'SubtotalWithoutDiscount' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'default' => '0.00'),
		'ShippingSubTotal' => Array ('type' => 'float', 'formatter' => 'kFormatter', 'format' => '%01.2f', 'default' => '0.00'),
		'OrderNumber' => Array ('type' => 'string', 'default' => '', 'filter_type' => 'like'),
		'CouponCode' => Array ('type' => 'string', 'default' => ''),
		'CouponName' => Array ('type' => 'string', 'default' => ''),
		'GiftCertificateCode' => Array ('type' => 'string', 'default' => ''),
		'GiftCertificateRecipient' => Array ('type' => 'string', 'default' => ''),

		// for ResetToUser
		'UserTo' => Array ('type' => 'string', 'default' => ''),
		'UserCompany' => Array ('type' => 'string', 'default' => ''),
		'UserPhone' => Array ('type' => 'string', 'default' => ''),
		'UserFax' => Array ('type' => 'string', 'default' => ''),
		'UserEmail' => Array ('type' => 'string', 'default' => ''),
		'UserAddress1' => Array ('type' => 'string', 'default' => ''),
		'UserAddress2' => Array ('type' => 'string', 'default' => ''),
		'UserCity' => Array ('type' => 'string', 'default' => ''),
		'UserState' => Array ('type' => 'string', 'default' => ''),
		'UserZip' => Array ('type' => 'string', 'default' => ''),
		'UserCountry' => Array ('type' => 'string', 'default' => ''),

		// for Search
		'Username' => Array ('type' => 'string', 'filter_type' => 'like', 'default' => ''),
		'HasBackOrders' => Array ('type' => 'int', 'default' => 0),
		'PaymentCVV2' => Array ('type' => 'string', 'default' => ''),
		'AffiliateUser' => Array ('type' => 'string', 'filter_type' => 'like', 'default' => ''),
		'AffiliatePortalUserId' => Array ('type' => 'int', 'default' => 0),

		// export related fields: begin
		'ExportFormat' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CSV', /*2 => 'XML'*/), 'default' => 1),
		'ExportFilename' => Array ('type' => 'string', 'default' => ''),
		'FieldsSeparatedBy' => Array ('type' => 'string', 'default' => ', '),
		'FieldsEnclosedBy' => Array ('type' => 'string', 'default' => '"'),
		'LineEndings' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'Windows', 2 => 'UNIX'), 'default' => 1),
		'LineEndingsInside' => Array ('type' => 'int', 'formatter' => 'kOptionsFormatter', 'options' => Array (1 => 'CRLF', 2 => 'LF'), 'default' => 2),
		'IncludeFieldTitles' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'default' => 1,
		),
		'ExportColumns' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
		'AvailableColumns' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
		'ExportPresets' => Array ('type' => 'string', 'formatter' => 'kOptionsFormatter', 'options' => Array (), 'default' => ''),
		'ExportSavePreset' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'default' => 0,
		),
		'ExportPresetName' => Array ('type' => 'string', 'default' => ''),
		// export related fields: end

		// for "one step checkout"
		'UserPassword' => Array (
			'type' => 'string',
			'formatter' => 'kPasswordFormatter', 'hashing_method' => PasswordHashingMethod::MD5, 'verify_field' => 'VerifyUserPassword',
			'skip_empty' => 1, 'default' => 'd41d8cd98f00b204e9800998ecf8427e'
		),

		// for "Shipping Info" step during Checkout
		'ShippingTypeId' => Array ('type' => 'array', 'default' => ''),
	),
	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				1 => 'icon16_pending.png',
				5 => 'icon16_disabled.png',
				'module' => 'core',
			),

			'Fields' => Array (
				'OrderId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
				'OrderNumber' => Array ( 'data_block' => 'grid_ordernumber_td', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'OrderDate' => Array ( 'title' => 'la_col_OrderDate', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
				'CustomerName' => Array ( 'title' => 'la_col_CustomerName', 'data_block' => 'grid_userlink_td', 'user_field' => 'PortalUserId', 'filter_block' => 'grid_like_filter', 'width' => 140, ),
				'PaymentType' => Array ( 'data_block' => 'grid_billinglink_td', 'filter_block' => 'grid_options_filter', 'width' => 140, ),
				'TotalAmount' => Array ( 'data_block' => 'grid_previewlink_td', 'filter_block' => 'grid_range_filter', 'width' => 140, ),
				'AffiliateUser' => Array ( 'data_block' => 'grid_userlink_td', 'user_field' => 'AffiliatePortalUserId', 'filter_block' => 'grid_like_filter', 'width' => 140, ),
				'OnHold' => Array ('filter_block' => 'grid_options_filter', 'width' => 100, ),
			),
		),

		'Search' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				1 => 'icon16_pending.png',
				5 => 'icon16_disabled.png',
				'module' => 'core',
			),
			'Fields' => Array (
				'OrderId' => Array ('title' => 'column:la_fld_Id', 'data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter', 'width' => 70, ),
				'OrderNumber' => Array ('data_block' => 'grid_ordernumber_td', 'filter_block' => 'grid_like_filter', 'width' => 100, ),
				'Status' => Array ('filter_block' => 'grid_options_filter', 'filter_block' => 'grid_options_filter', 'width' => 100, ),
				'OrderDate' => Array ('title' => 'la_col_OrderDate', 'filter_block' => 'grid_date_range_filter', 'width' => 140, ),
				'CustomerName' => Array ('title' => 'la_col_CustomerName', 'data_block' => 'grid_userlink_td', 'user_field' => 'PortalUserId', 'filter_block' => 'grid_like_filter'),
				'PaymentType' => Array ('data_block' => 'grid_billinglink_td', 'filter_block' => 'grid_options_filter'),
				'TotalAmount' => Array ('data_block' => 'grid_previewlink_td', 'filter_block' => 'grid_range_filter'),
				'AffiliateUser' => Array ('data_block' => 'grid_userlink_td', 'user_field' => 'AffiliatePortalUserId', 'filter_block' => 'grid_user_like_filter'),
				'OrderIP' => Array ('filter_block' => 'grid_like_filter'),
				'Username' => Array ('filter_block' => 'grid_user_like_filter'),
				'PaymentAccount' => Array ('title' => 'column:la_fld_CreditCardNumber', 'filter_block' => 'grid_like_filter'),
			),
		),
	),
);
