<?php
/**
* @version	$Id: reports_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'rep',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'ReportsEventHandler', 'file' => 'reports_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'ReportsTagProcessor', 'file' => 'reports_tag_processor.php', 'build_event' => 'OnBuild'),
	'AutoLoad' => true,

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
		5 => 'mode',
	),

	'Hooks' => Array (
		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'rep',
			'HookToSpecial' => '*',
			'HookToEvent' => Array ('OnAfterConfigRead'),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnUpdateConfig',
		),
	),

	'IDField' => 'CategoryId',

	'TitlePresets' => Array (
		'default' => Array (
			'new_status_labels' => Array ('d' => '!la_title_Adding_Discount!'),
			'edit_status_labels' => Array ('d' => '!la_title_Editing_Discount!'),
			'new_titlefield' => Array ('d' => '!la_title_New_Discount!'),
		),

		'report_options' =>Array ('format' => "!la_title_ReportOptions!"),
		'report_results' =>Array ('format' => "!la_title_ReportResults!"),
		'report_chart' =>Array ('format' => "!la_title_SalesReportChart!"),
	),

	'PermSection' => Array ('main' => 'in-commerce:reports'),

	'Sections' => Array (
		'in-commerce:reports' => Array (
			'parent' => 'in-commerce',
			'icon' => 'in-commerce:sales_report',
			'label' => 'la_tab_SaleReports',
			'url' => Array ('t' => 'in-commerce/reports/reports', 'pass' => 'm,rep', 'rep_event' => 'OnNew'),
			'permissions' => Array ('view', 'add'),
			'priority' => 2,
			'type' => stTREE,
		),
	),

	'ListSQLs' => Array (
		'' => '	SELECT %1$s.* %2$s
				FROM %1$s',
	),

	'ListSortings' => Array (
		'' => Array (
			'Sorting' => Array ('Name' => 'asc'),
		)
	),

	'CalculatedFields' => Array (
		'' => Array (
			'CategoryId' => '0',
		),
	),

	'VirtualFields' => Array (
		'ReportType' => array('formatter' => 'kOptionsFormatter', 'options' =>array(
				12 => 'la_Overall',
				1 => 'la_ByCategory',
				2 => 'la_ByUser',
				5 => 'la_byProduct'
			),
			'use_phrases' => 1, 'default' => 12,
		),
		'FromDateTime' => Array ('formatter' => 'kDateFormatter', 'default' => '', 'filter_type' => 'range_from', 'filter_field' => 'OrderDate' ),
		'ToDateTime' => Array ('formatter' => 'kDateFormatter', 'default' => '', 'filter_type' => 'range_to', 'filter_field' => 'OrderDate', 'empty_time' => adodb_mktime(23,59,59) ),
		'Recursive' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'not_null' => 1, 'default' => 1,
		),
		'SkipEmpty' => Array (
			'type' => 'int',
			'formatter' => 'kOptionsFormatter',
			'options' => Array (0 => 'la_No', 1 => 'la_Yes'),
			'use_phrases' => 1, 'not_null' => 1, 'default' => 1,
		),
		'CategoryId' => Array ('type' => 'int', 'default' => 0),
	),

	'Grids' => Array (
		'Default' => Array (
			'Icons' => Array (
				'default' => 'icon16_item.png',
				'module' => 'core',
			),
			'Fields' => Array (
				'Name' => Array ('data_block' => 'grid_checkbox_td', 'filter_block' => 'grid_range_filter'),
				'Start' => Array ('filter_block' => 'grid_date_range_filter'),
				'End' => Array ('filter_block' => 'grid_date_range_filter'),
				'GroupId' => Array ( 'title' => 'column:la_fld_Group', 'filter_block' => 'grid_options_filter'),
				'Type' => Array ('filter_block' => 'grid_options_filter'),
				'Amount' => Array ('filter_block' => 'grid_range_filter'),
			),
		),
	),
);
