<?php
/**
* @version	$Id: gateways_config.php 16385 2016-08-11 08:15:43Z alex $
* @package	In-Commerce
* @copyright	Copyright (C) 1997 - 2009 Intechnic. All rights reserved.
* @license	Commercial License
* This software is protected by copyright law and international treaties.
* Unauthorized reproduction or unlicensed usage of the code of this program,
* or any portion of it may result in severe civil and criminal penalties,
* and will be prosecuted to the maximum extent possible under the law
* See http://www.in-portal.org/commercial-license for copyright notices and details.
*/

defined('FULL_PATH') or die('restricted access!');

$config = Array (
	'Prefix' => 'gwf',
	'ItemClass' => Array ('class' => 'kDBItem', 'file' => '', 'build_event' => 'OnItemBuild'),
	'ListClass' => Array ('class' => 'kDBList', 'file' => '', 'build_event' => 'OnListBuild'),
	'EventHandlerClass' => Array ('class' => 'GatewayEventHandler', 'file' => 'gw_event_handler.php', 'build_event' => 'OnBuild'),
	'TagProcessorClass' => Array ('class' => 'GatewayTagProcessor', 'file' => 'gw_tag_processor.php', 'build_event' => 'OnBuild'),

	'RegisterClasses' => array(
		array('pseudo' => 'kGWBase', 'class' => 'kGWBase', 'file' => 'gw_classes/gw_base.php', 'build_event' => ''),
		array('pseudo' => 'kAtosOriginGW', 'class' => 'kAtosOriginGW', 'file' => 'gw_classes/atosorigin.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kGWAuthorizeNet', 'class' => 'kGWAuthorizeNet', 'file' => 'gw_classes/authorizenet.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kGWGoogleCheckout', 'class' => 'kGWGoogleCheckout', 'file' => 'gw_classes/google_checkout.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kGWiDEALnl', 'class' => 'kGWiDEALnl', 'file' => 'gw_classes/ideal_nl.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kMultiCardsGW', 'class' => 'kMultiCardsGW', 'file' => 'gw_classes/multicards.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kPayboxGW', 'class' => 'kPayboxGW', 'file' => 'gw_classes/paybox.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kPaymentechGW', 'class' => 'kPaymentechGW', 'file' => 'gw_classes/paymentech.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kGWPayPal', 'class' => 'kGWPayPal', 'file' => 'gw_classes/paypal.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kGWPaypalDirect', 'class' => 'kGWPaypalDirect', 'file' => 'gw_classes/paypal_direct.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kGWRightConnect', 'class' => 'kGWRightConnect', 'file' => 'gw_classes/rightconnect.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kSellaGuestPayGW', 'class' => 'kSellaGuestPayGW', 'file' => 'gw_classes/sella_guestpay.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kVerisignPfLinkGW', 'class' => 'kVerisignPfLinkGW', 'file' => 'gw_classes/verisign_pflink.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
		array('pseudo' => 'kGWWorldPay', 'class' => 'kGWWorldPay', 'file' => 'gw_classes/worldpay.php', 'build_event' => '', 'require_classes' => 'kGWBase'),
	),

	'AutoLoad' => true,

	'Hooks' => Array (
		Array (
			'Mode' => hBEFORE,
			'Conditional' => false,
			'HookToPrefix' => 'pt',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnListBuild' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnCheckGateways',
		),
		Array (
			'Mode' => hBEFORE,
			'Conditional' => true,
			'HookToPrefix' => 'pt',
			'HookToSpecial' => '',
			'HookToEvent' => Array ( 'OnCreate', 'OnSave', 'OnUpdate', 'onPreSaveAndGoToTab', 'onPreSaveAndGo' ),
			'DoPrefix' => '',
			'DoSpecial' => '',
			'DoEvent' => 'OnSaveValues',
		),
	),

	'QueryString' => Array (
		1 => 'id',
		2 => 'Page',
		3 => 'PerPage',
		4 => 'event',
	),

	'IDField' => 'GWConfigFieldId',
	'TableName' => TABLE_PREFIX.'GatewayConfigFields',

	'ListSQLs' => Array (
		'' => '	SELECT *
				FROM %s',
	),

	'Fields' => Array (
		'GWConfigFieldId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
		'SystemFieldName' => Array ('type' => 'string', 'not_null' => 1, 'default' => '', ),
		'FieldName' => Array ('type' => 'string', 'required' => true, 'max_len' => 100, 'not_null' => 1, 'default' => '', ),
		'ElementType' => Array ('type' => 'string', 'not_null' => 1, 'default' => 'text', ),
		'ValueList' => Array ('type' => 'string', 'default' => NULL),
		'GatewayId' => Array ('type' => 'int', 'not_null' => 1, 'default' => 0, ),
	),

	'VirtualFields' => Array (
		'Value' => Array ('type' => 'string', 'default' => ''),
	),
);
